<?php
header("Content-type: application/vnd.ms-excel");
header("Content-Disposition: attachment;filename=reporte_produccionxterceros.xls");
include 'clases/clinica.class.php';
session_start();
if (!isset($_SESSION["accessauthority"])){
	header("location:index.php");
	exit();}
?>
<html>
<head></head>
<body>
<?php
$cn=conectar();
$idcentro=$_SESSION['idoperativo'];	
$cad="select to_char(cb.fecha_atencion,'dd/mm/yyyy') as fecha_atencion,b.bus,
(pe.ape_paterno||' '||pe.ape_materno||', '||pe.nombres) as medico,
tt.descripcion as turno,c.descripcion as especialidad,i.nom_raz_soc,
ti.serie,ti.nro_ticket,dv.val_abr as dventa,fp.descripcion as forma,
(p.ape_paterno||' '||p.ape_materno||', '||p.nombre) as paciente,pr.descripcion as producto,
d.cantidad,
case when ti.moneda='0' then d.monto else 
(d.monto*ti.cambio) end as precio,
case when ti.moneda='0' then d.dscto else 
(d.dscto*ti.cambio) end as dscto,
case when ti.moneda='0' then d.cantidad*(d.monto-d.dscto) else 
d.cantidad*((d.monto*ti.cambio)-(d.dscto*ti.cambio)) end as total
from cab_cie10 cb 
inner join tickets ti on cb.nro_historia=ti.nro_historia
inner join consultorios c on ti.id_consultorio=c.id_consultorio
inner join buses b on cb.id_bus=b.id_bus
left join institucion i on b.id_emp=i.id_inst
inner join pacientes p on ti.id_paciente=p.id_paciente
inner join personal pe on cb.cmp=pe.id_personal
inner join detalles d on ti.nro_historia=d.nro_historia
inner join  productos pr on d.id_producto=pr.id_producto
inner join tablatipo dv on ti.dventa=dv.id_tipo and dv.id_tabla='10' 
inner join tablatipo fp on ti.forpago=fp.id_tipo and fp.id_tabla='12' 
inner join tablatipo tt on cb.turno=tt.id_tipo and tt.id_tabla='7' 
where cb.nro_historia<>'' ";
$cri_fe='';
$cri_fp='';
if ($_GET['flag_f']!=''){ //por fechas
	$cad.="and to_char(cb.fecha_atencion,'dd/mm/yyyy') in (";
	$ary=explode(',',$_GET['fechas']);
	for($i=0;$i<count($ary);$i++){
		 $cri_fe.="'".$ary[$i]."',";
	}
	$cad.=$cri_fe."'') ";
}else{ //por periodo 
	$qry="select to_char(date_ini,'dd/mm/yyyy') as desde, to_char(date_end,'dd/mm/yyyy') as hasta from perpago where id_per='".$_GET['id_periodo']."'";
	$rsp=pg_query($cn,$qry);
	$nrp=pg_num_rows($rsp);
	if ($nrp>0)	$cad.="and cb.fecha_atencion>='".pg_fetch_result($rsp,0,'desde')." 12:00 AM' and cb.fecha_atencion<='".pg_fetch_result($rsp,0,'hasta')." 11:59 PM'";
}
if (!empty($_GET['idc'])){
	$cad.="and ti.id_consultorio='".$_GET['idc']."' ";			
}
if (!empty($_GET['idb'])){
	$cad.="and cb.id_bus='".$_GET['idb']."' ";			
}
if (!empty($_GET['idm'])){
	$cad.="and cb.cmp='".$_GET['idm']."' ";			
}
if (!empty($_GET['idt'])){
	$cad.="and cb.turno='".$_GET['idt']."' ";			
}
if (!empty($_GET['idtip'])){
	$cad.="and pr.tipo='".$_GET['idtip']."' ";			
}
if ($_GET['id_f']!=''){ 
	$cad.="and ti.forpago in (";
	$ary=explode(',',$_GET['id_f']);
	for($i=0;$i<count($ary);$i++){
		 $cri_fp.="'".$ary[$i]."',";
	}
	$cad.=$cri_fp."'') ";
}
if ($_GET['id_s']=='I'){
	$cad.="and cb.id_per is null ";	
}elseif($_GET['id_s']=='P'){
	$cad.="and cb.id_per is not null ";
}

$cad.="order by cb.fecha_atencion,dv.val_abr,ti.serie,ti.nro_ticket";
$rs=pg_query($cn,$cad);	
$nr=pg_num_rows($rs);


?>
 <style type="text/css">
    <!--
    .xl65
    {
        mso-style-parent:style0;
        mso-number-format:"\@";
    }
    -->
    </style>
<table border="1" cellpadding="1" cellspacing="1">
<tr>
<td nowrap="nowrap">Fecha Atencion</td>
<td nowrap="nowrap">Tipo</td>
<td nowrap="nowrap">Serie</td>
<td nowrap="nowrap">Numero</td>
<td nowrap="nowrap">Forma Pago</td>
<td nowrap="nowrap">Especialidad</td>
<td nowrap="nowrap">Consultorio</td>
<td nowrap="nowrap">Razon Social</td>
<td nowrap="nowrap">Medico</td>
<td nowrap="nowrap">Turno</td>
<td nowrap="nowrap">Paciente</td>
<td nowrap="nowrap">Producto</td>
<td nowrap="nowrap">Cantidad</td>
<td nowrap="nowrap">Precio</td>
<td nowrap="nowrap">Descuento</td>
<td nowrap="nowrap">Total</td>
</tr><?
for ($i=0;$i<$nr;$i++){
	?><tr>		
		<td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'fecha_atencion'); ?></td>
		<td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'dventa'); ?></td>
        <td nowrap="nowrap" class="xl65"><? echo pg_fetch_result($rs,$i,'serie'); ?></td>
        <td nowrap="nowrap" class="xl65"><? echo pg_fetch_result($rs,$i,'nro_ticket'); ?></td>
		<td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'forma'); ?></td>
        <td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'especialidad'); ?></td>
        <td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'bus'); ?></td>
        <td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'nom_raz_soc'); ?></td>
        <td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'medico'); ?></td>
		<td nowrap="nowrap"><? echo utf8_decode(pg_fetch_result($rs,$i,'turno')); ?></td>
        <td nowrap="nowrap"><? echo utf8_decode(pg_fetch_result($rs,$i,'paciente')); ?></td>
        <td nowrap="nowrap"><? echo utf8_decode(pg_fetch_result($rs,$i,'producto')); ?></td>
		<td nowrap="nowrap"><? echo pg_fetch_result($rs,$i,'cantidad'); ?></td>        
		<td nowrap="nowrap" style="mso-number-format:'0.00';"><? echo number_format(pg_fetch_result($rs,$i,'precio'),2,'.',','); ?></td>
        <td nowrap="nowrap" style="mso-number-format:'0.00';"><? echo number_format(pg_fetch_result($rs,$i,'dscto'),2,'.',','); ?></td>
        <td nowrap="nowrap" style="mso-number-format:'0.00';"><? echo number_format(pg_fetch_result($rs,$i,'total'),2,'.',','); ?></td>
		</tr>
	<? } 
	pg_free_result($rs);
	pg_close($cn);
?>
</table>
</body>
</html>