<?php
include('nusoap/lib/nusoap.php');
include 'clases/clinica.class.php';
$server = new nusoap_server;
$server->configureWSDL('wssisol', 'urn:wssisol');
$server->wsdl->schemaTargetNamespace='urn:wssisol';
ini_set("default_socket_timeout", 10);
//$server->register('get_head_invoice',array('dventa'=>'xsd:string','serie'=>'xsd:string','nro_ticket'=>'xsd:string','id_consultorio'=>'xsd:string','especialidad'=>'xsd:string','mode'=>'xsd:string')); 
$server->wsdl->addComplexType(
    'aauxiliares',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'especialidad' => array('name' => 'especialidad', 'type' => 'xsd:string'),
	'producto' => array('name' => 'producto', 'type' => 'xsd:string'),
	'cantidad' => array('name' => 'cantidad', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'auxiliares_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:aauxiliares[]')),//the attributes of our array.
'tns:aauxiliares'// what type of array is this?  Oh it's an array of mytable data
);



$server->wsdl->addComplexType(
    'adetalles',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'descripcion' => array('name' => 'descripcion', 'type' => 'xsd:string'),
	'cantidad' => array('name' => 'cantidad', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'detalles_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:adetalles[]')),//the attributes of our array.
'tns:adetalles'// what type of array is this?  Oh it's an array of mytable data
);
$server->wsdl->addComplexType(
    'acie10',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'cie10' => array('name' => 'cie10', 'type' => 'xsd:string'),
	'descripcion' => array('name' => 'descripcion', 'type' => 'xsd:string'),
	'tipo' => array('name' => 'tipo', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'cie10_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:acie10[]')),//the attributes of our array.
'tns:acie10'// what type of array is this?  Oh it's an array of mytable data
);



$server->wsdl->addComplexType(
    'apaquetes_uni',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'especialidad' => array('name' => 'especialidad', 'type' => 'xsd:string'),
	'id_producto' => array('name' => 'id_producto', 'type' => 'xsd:string'),
	'producto' => array('name' => 'producto', 'type' => 'xsd:string')	
	)
);
$server->wsdl->addComplexType(
'paquetes_uni_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:apaquetes_uni[]')),//the attributes of our array.
'tns:apaquetes_uni'// what type of array is this?  Oh it's an array of mytable data
);

$server->wsdl->addComplexType(
    'aafiliado_uni',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'nombre' => array('name' => 'nombre', 'type' => 'xsd:string'),
	'ape_paterno' => array('name' => 'ape_paterno', 'type' => 'xsd:string'),
	'ape_materno' => array('name' => 'ape_materno', 'type' => 'xsd:string'),
	'tip_doc' => array('name' => 'tip_doc', 'type' => 'xsd:string'),
	'nro_doc' => array('name' => 'nro_doc', 'type' => 'xsd:string'),
	'fecha_nac' => array('name' => 'fecha_nac', 'type' => 'xsd:string'),
	'sexo' => array('name' => 'sexo', 'type' => 'xsd:string'),
	'direccion' => array('name' => 'direccion', 'type' => 'xsd:string'),
	'id_distrito' => array('name' => 'id_distrito', 'type' => 'xsd:string'),
	'codigo' => array('name' => 'codigo', 'type' => 'xsd:string'),	
	'id_afiliado' => array('name' => 'id_afiliado', 'type' => 'xsd:string'),
	'id_orden' => array('name' => 'id_orden', 'type' => 'xsd:string'),
	'fecha_orden' => array('name' => 'fecha_orden', 'type' => 'xsd:string'),
	'id_paquete' => array('name' => 'id_paquete', 'type' => 'xsd:string'),
	'latendido' => array('name' => 'latendido', 'type' => 'xsd:string'),
	'apaquetes' => array('name' => 'apaquetes', 'type' => 'tns:paquetes_uni_array')
	)
);

$server->wsdl->addComplexType(
'main_afiliado_uni',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:aafiliado_uni[]')),//the attributes of our array.
'tns:aafiliado_uni'// what type of array is this?  Oh it's an array of mytable data
);

$server->register('get_afiliado_uni', array('IdEess'=>'xsd:string','TipoDoc'=>'xsd:string','Documento'=>'xsd:string','Id_orden'=>'xsd:string'),
array('return' => 'tns:main_afiliado_uni'),     
    'urn:wssisol',                    
    'urn:wssisol#get_afiliado_uni',          
    'rpc',                               
    'encoded',                            
    'WS Datos Afiliados UNI'); 

$server->register('put_update_os', array('IdEess'=>'xsd:string','Id_orden'=>'xsd:string','Id_afiliado'=>'xsd:string','Nro_historias'=>'xsd:string'),
array('return' => 'xsd:string'),     
    'urn:wssisol',                    
    'urn:wssisol#put_update_os',          
    'rpc',                               
    'encoded',                            
    'WS Update Orden de Servicio');




/*Estructura para recepcion de datos de venta de SIS*/
$server->wsdl->addComplexType(
    'adet_ven_sis',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'id_prod' => array('name' => 'id_prod', 'type' => 'xsd:string'),
	'producto' => array('name' => 'producto', 'type' => 'xsd:string'),
	'codigo' => array('name' => 'codigo', 'type' => 'xsd:string'),	
	'tarifa' => array('name' => 'tarifa', 'type' => 'xsd:string'),
	'cant' => array('name' => 'cant', 'type' => 'xsd:string'),
	'id_aden' => array('name' => 'id_aden', 'type' => 'xsd:string'),
	'in_neu' => array('name' => 'in_neu', 'type' => 'xsd:string')		
	)
);
$server->wsdl->addComplexType(
'det_sis_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:adet_ven_sis[]')),//the attributes of our array.
'tns:adet_ven_sis'// what type of array is this?  Oh it's an array of mytable data
);

$server->wsdl->addComplexType(
    'adatos_ins_sis',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'renaes' => array('name' => 'renaes', 'type' => 'xsd:string'),
	'ccosto' => array('name' => 'ccosto', 'type' => 'xsd:string'),
	'n_rec_s' => array('name' => 'n_rec_s', 'type' => 'xsd:string'),	
	'f_emis' => array('name' => 'f_emis', 'type' => 'xsd:string'),
	'n_com' => array('name' => 'n_com', 'type' => 'xsd:string'),
	'dni' => array('name' => 'dni', 'type' => 'xsd:string'),
	'ape_nom' => array('name' => 'ape_nom', 'type' => 'xsd:string'),
	'especialidad' => array('name' => 'especialidad', 'type' => 'xsd:string'),
	'st_rv' => array('name' => 'st_rv', 'type' => 'xsd:string'),
	'llave' => array('name' => 'llave', 'type' => 'xsd:string'),
	'adet_venta_sis' => array('name' => 'apaquetes', 'type' => 'tns:det_sis_array')
	)
);

$server->wsdl->addComplexType(
'ventas_sis_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:adatos_ins_sis[]')),//the attributes of our array.
'tns:adatos_ins_sis'// what type of array is this?  Oh it's an array of mytable data
);	
function conectar_mssql(){
	$cn_mssql=mssql_connect('192.168.1.243','sis','SiSoL2014') or die("Error de conexión.");
	mssql_select_db('sis_ep',$cn_mssql) or die("Error de selección de base de datos."); 
	return $cn_mssql;
}

$server->register('insert_venta_sis', array('aventas_sis'=>'tns:ventas_sis_array'),
array('return' => 'xsd:string'),     
    'urn:wssisol',                    
    'urn:wssisol#insert_venta_sis',          
    'rpc',                               
    'encoded',                            
    'WS Envio de Datos Venta SIS');

function insert_venta_sis($adatos){
	$cn=conectar_mssql();
	$adet=$adatos[0]['adet_venta_sis'];
	$ndet=count($adet);
	for($i=0;$i<$ndet;$i++){
		$sq="insert into sisreg(renaes,ccosto,n_rec_s,f_emis,n_com,dni,ape_nom,especialidad,id_prod,producto,codigo,tarifa,cant,id_aden,in_neu,llave) 
			values('".$adatos[0]['renaes']."','".$adatos[0]['ccosto']."','".$adatos[0]['n_rec_s']."','".$adatos[0]['f_emis']."','".$adatos[0]['n_com']."',
			'".$adatos[0]['dni']."','".$adatos[0]['ape_nom']."','".$adatos[0]['especialidad']."','".$adet[$i]['id_prod']."','".$adet[$i]['producto']."','".$adet[$i]['codigo']."','".$adet[$i]['tarifa']."','".$adet[$i]['cant']."','".$adet[$i]['id_aden']."','".$adet[$i]['in_neu']."','".$adatos[0]['llave']."')";
		mssql_query($sq,$cn);			
	}
	$msg='OK';
	return $msg;
}


$server->register('put_valida_sis', array('historia'=>'xsd:string','cpt'=>'xsd:string','id_correlativo'=>'xsd:string'),
array('return' => 'xsd:Array'),     
    'urn:wssisol',                    
    'urn:wssisol#put_valida_sis',          
    'rpc',                               
    'encoded',                            
    'WS Resultados Valida Sis'); 

function put_valida_sis($historia,$cpt,$id_correlativo){
	$cn=conectar_mssql();
	$avalsis=array();
	$sq="select * from sisreg where n_rec_s='".$historia."' and id_prod='".$cpt."' order by n_ord asc ";
	//$sq="select * from sisreg where n_ord='".$id_correlativo."' and n_rec_s='".$historia."' and id_prod='".$cpt."' order by n_ord asc ";
	//$sq="select * from sisreg where n_ord='114' and n_rec_s='CJP5-003-10002' and id_prod='CJP1225' ";
 	$rs=mssql_query($sq,$cn);	
	$nr=mssql_num_rows($rs);
	if ($nr>0){
		$matr_aud = mssql_fetch_object($rs);
		$id_si=$matr_aud->situac;
		if (!empty($id_si)){
			$avalsis[0]['ValidaResultSis']=utf8_encode($matr_aud->situac).'|'.utf8_encode($matr_aud->criter).'|'.utf8_encode($matr_aud->d_crit).'|'.utf8_encode($matr_aud->eval_o).'|'.utf8_encode($matr_aud->id_file1).'|'.utf8_encode($matr_aud->f_apro).'|'.utf8_encode($matr_aud->obs).'|'.utf8_encode($matr_aud->n_rec_s);
 		}
	return $avalsis;
	}
}

 

$server->register('put_envio_sis',array('historia'=>'xsd:string','fecha_corte'=>'xsd:string','name_per'=>'xsd:string','t_per'=>'xsd:string','nro_orden'=>'xsd:string','id_producto'=>'xsd:string'), 
array('return' => 'xsd:string'),
    'urn:wssisol',
    'urn:wssisol#put_envio_sis',
    'rpc',
    'encoded',
    'Web Service Insertar Registros'); 
	
 
function put_envio_sis($historia,$fecha_corte,$name_per,$t_per,$nro_orden,$id_producto){
	$cn=conectar_mssql();
	$ins="update sisreg set n_ord='".$nro_orden."', f_cort='".$fecha_corte."', n_per='".$name_per."', t_per='".$t_per."' where n_rec_s='".$historia."' and id_prod='".$id_producto."'  ";
 	$rs = mssql_query($ins,$cn);
	return 'I';
}
$server->register('put_atencion_sis', array('nro_historia'=>'xsd:string','f_aten'=>'xsd:string','t_cons'=>'xsd:string','ruc'=>'xsd:string','n_cons'=>'xsd:string',  
'especialista'=>'xsd:string','cmp'=>'xsd:string','e_dni'=>'xsd:string','nom_raz_soc'=>'xsd:string'),
array('return' => 'xsd:string'),     
    'urn:wssisol',                    
    'urn:wssisol#put_atencion_sis',          
    'rpc',                               
    'encoded',                            
    'WS Insert Atencion SIS');

function put_atencion_sis($nh,$fa,$tc,$ruc,$ncon,$esp,$cmp,$edni,$raz){
	$cn=conectar_mssql();
	$sq="select n_rec_s from sisreg where n_rec_s='".$nh."'";
	$rs=mssql_query($sq,$cn);
	$nf=mssql_num_rows($rs);
	$msg='';
	if($nf<=0){
		$msg='Error no se hallo Nro de Historia';
	}else{
		$upd="update sisreg set f_aten='".$fa."',t_cons='".$tc."',ruc='".$ruc."',n_cons='".$ncon."',especialista='".$esp."',cmp='".$cmp."',e_dni='".$edni."',nom_raz_soc='".$raz."' where n_rec_s='".$nh."'";
		mssql_query($upd,$cn);		
		$msg='OK';
	}
	return $msg;
}

$server->register('put_anula_sis', array('nro_historia'=>'xsd:string'),
array('return' => 'xsd:string'),     
    'urn:wssisol',                    
    'urn:wssisol#put_anula_sis',          
    'rpc',                               
    'encoded',                            
    'WS Anulacion Atencion SIS');

function put_anula_sis($nh){
	$cn=conectar_mssql();
	$sq="select n_rec_s from sisreg where n_rec_s='".$nh."'";
	$rs=mssql_query($sq,$cn);
	$nf=mssql_num_rows($rs);
	$msg='';
	if($nf<=0){
		$msg='Error no se hallo Nro de Historia';
	}else{
		$upd="update sisreg set st_rv='S' where n_rec_s='".$nh."'";
		mssql_query($upd,$cn);		
		$msg='OK';
	}
	return $msg;
}




/*fin de ws para envio sis*/




function put_update_os($ideess,$id_orden,$id_afiliado,$nro_historias){	
	$msg='';$cn=conectar();
	if ($id_orden==''){
		$msg='02-No se envio nro de orden';
	}elseif($id_afiliado==''){
		$msg='03-No se envio ID del afiliado';
	}elseif($nro_historias==''){
		$msg='04-No se envio relacion de comprobantes';
	}else{
		$sq="select id_orden,id_afiliado from det_ordenes_uni where id_orden='".$id_orden."' and id_afiliado='".$id_afiliado."'";
		$rso=pg_query($cn,$sq);
		$nr=pg_num_rows($rso);
		if ($nr>0){
			$up="update det_ordenes_uni set latendido='".$nro_historias."' where id_orden='".$id_orden."' and id_afiliado='".$id_afiliado."'";
			pg_query($cn,$up);
			$msg='01-OK';
		}else{
			$msg='05-No se encontro registros con estos criterios.';
		}
	}
	return $msg;
}


function get_afiliado_uni($ideess,$tipodoc,$documento,$id_orden){
	$aux='';$cn=conectar();
	if ($id_orden!='' && $documento!=''){
		$aux="o.id_orden='".$id_orden."' and a.nro_doc='".$documento."' ";
	}elseif($id_orden!='' && $documento==''){
		$aux="o.id_orden='".$id_orden."' ";
	}elseif($id_orden=='' && $documento!=''){
		$aux="a.nro_doc='".$documento."' ";
	}
	$sq="select a.*, o.id_orden, to_char(o.fecha_orden,'dd/mm/yyyy') as fecha_orden,o.id_paquete,d.latendido 
	from det_ordenes_uni d inner join afiliados_uni a on d.id_afiliado=a.id_afiliado inner join ordenes_uni o on d.id_orden=o.id_orden where ".$aux." order by o.fecha_orden desc";
	$rscb=pg_query($cn,$sq);
	$nrcb=pg_num_rows($rscb);
	$ah=array();
	for ($i=0;$i<$nrcb;$i++){	
		$aaux=array();
		$sq="select c.descripcion as especialidad,p.id_producto,p.descripcion as producto from ordenes_uni o inner join paquetes_uni paq on o.id_paquete=paq.id_paquete 
		    inner join productos_master p on p.id_producto=paq.id_producto inner join consultorios_master c on c.id_consultorio=substring(p.id_producto,1,3)
			where o.id_orden='".pg_fetch_result($rscb,0,'id_orden')."' order by c.descripcion,p.descripcion ";
		$rs=pg_query($cn,$sq);
		$nrp=pg_num_rows($rs);
		for ($j=0;$j<$nrp;$j++){
			$aaux[$j]=array(
				'especialidad'=>pg_fetch_result($rs,$j,'especialidad'),
				'id_producto'=>pg_fetch_result($rs,$j,'id_producto'),
				'producto'=>pg_fetch_result($rs,$j,'producto')				
			);	
		}
					
		$ah[$i]=array(
		'nombre'=>pg_fetch_result($rscb,$i,'nombre'),
		'ape_paterno'=>pg_fetch_result($rscb,$i,'ape_paterno'),
		'ape_materno'=>pg_fetch_result($rscb,$i,'ape_materno'),
		'tip_doc'=>pg_fetch_result($rscb,$i,'tip_doc'),
		'nro_doc'=>pg_fetch_result($rscb,$i,'nro_doc'),
		'fecha_nac'=>pg_fetch_result($rscb,$i,'fecha_nac'),
		'sexo'=>pg_fetch_result($rscb,$i,'sexo'),
		'direccion'=>pg_fetch_result($rscb,$i,'direccion'),
		'id_distrito'=>pg_fetch_result($rscb,$i,'id_distrito'),
		'codigo'=>pg_fetch_result($rscb,$i,'codigo'),
		'id_afiliado'=>pg_fetch_result($rscb,$i,'id_afiliado'),		
		'id_orden'=>pg_fetch_result($rscb,$i,'id_orden'),
		'fecha_orden'=>pg_fetch_result($rscb,$i,'fecha_orden'),
		'id_paquete'=>pg_fetch_result($rscb,$i,'id_paquete'),
		'latendido'=>pg_fetch_result($rscb,$i,'latendido'),
		'apaquetes'=>$aaux
		);
	}
	return $ah;
}




$server->wsdl->addComplexType(
    'amain_hc',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'peso' => array('name' => 'peso', 'type' => 'xsd:string'),
	'talla' => array('name' => 'talla', 'type' => 'xsd:string'),
	'presion_art' => array('name' => 'presion_art', 'type' => 'xsd:string'),
	'frecuencia_car' => array('name' => 'frecuencia_car', 'type' => 'xsd:string'),
	'frecuencia_res' => array('name' => 'frecuencia_res', 'type' => 'xsd:string'),
	'temperatura' => array('name' => 'temperatura', 'type' => 'xsd:string'),
	'motivo' => array('name' => 'motivo', 'type' => 'xsd:string'),
	'tratamiento' => array('name' => 'tratamiento', 'type' => 'xsd:string'),
	'relato_enf' => array('name' => 'relato_enf', 'type' => 'xsd:string'),
	'examen_c_g' => array('name' => 'examen_c_g', 'type' => 'xsd:string'),	
	'tiempo_enf' => array('name' => 'tiempo_enf', 'type' => 'xsd:string'),
	'inicio_enf' => array('name' => 'inicio_enf', 'type' => 'xsd:string'),
	'curso_enf' => array('name' => 'curso_enf', 'type' => 'xsd:string'),	
	'adetalles' => array('name' => 'adetalles', 'type' => 'tns:detalles_array'),
	'acie10' => array('name' => 'acie10', 'type' => 'tns:cie10_array'),
	'aauxiliares' => array('name' => 'aauxiliares', 'type' => 'tns:auxiliares_array')
	)
);
$server->wsdl->addComplexType(
'main_hc_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:amain_hc[]')),//the attributes of our array.
'tns:amain_hc'// what type of array is this?  Oh it's an array of mytable data
);





$server->register('BuscarAseguradosDocIdent', array('IdEess'=>'xsd:string','TipoDoc'=>'xsd:string','Documento'=>'xsd:string','Id_orden'=>'xsd:string'),
array('return' => 'xsd:Array'),     
    'urn:wssisol',                    
    'urn:wssisol#BuscarAseguradosDocIdent',          
    'rpc',                               
    'encoded',                            
    'WS Buscados Afiliados UNI'); 

function BuscarAseguradosDocIdent($ideess,$tipodoc,$documento,$id_orden){
	$cn=conectar();
	$auni=array();
	$sq="select * from afiliados_uni where tip_doc='".$tipodoc."' and nro_doc='".$documento."'";
	$rs=pg_query($cn,$sq);	
	$nr=pg_num_rows($rs);
	if ($nr>0){
		$auni[0]['BuscarAseguradosDocIdentResult']=$tipodoc.'|'.$documento.'|'.pg_fetch_result($rs,0,'ape_paterno').'|'.pg_fetch_result($rs,0,'ape_materno').'|'.
		pg_fetch_result($rs,0,'nombre').'|'.pg_fetch_result($rs,0,'id_esp').'|'.pg_fetch_result($rs,0,'id_distrito').'|'.pg_fetch_result($rs,0,'codigo').'||'.
		pg_fetch_result($rs,0,'fecha_nac').'|'.pg_fetch_result($rs,0,'sexo').'|'.pg_fetch_result($rs,0,'direccion');
	}
	return $auni;
}






$server->register('get_main_hc', array('nro_historia'=>'xsd:string'),
array('return' => 'xsd:Array'),     
    'urn:wssisol',                    
    'urn:wssisol#get_main_hc',          
    'rpc',                               
    'encoded',                            
    'WS Detalle de Historia Clinica'); 


function get_main_hc($hc){
	$cn=conectar();
	$sq="select id_dependencia,descripcion,url_dependencia,port_dependencia from hospitales where id_dependencia='".substr($hc,0,3)."' order by descripcion";
	$rs=pg_query($cn,$sq);	
	$url=pg_fetch_result($rs,0,'url_dependencia').':'.pg_fetch_result($rs,0,'port_dependencia').'/sisol/server_soap.php';	
	$client=new nusoap_client($url);
	$param=array('nro_historia'=>$hc);
	$response = $client->call('get_main_hc',$param);
	if($client->fault) {  
	} 
	$r=$response;
	return $r;
}

$server->wsdl->addComplexType(
    'ahistory',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'fecha_atencion' => array('name' => 'fecha_atencion', 'type' => 'xsd:string'),
	'medico' => array('name' => 'medico', 'type' => 'xsd:string'),
	'comprobante' => array('name' => 'comprobante', 'type' => 'xsd:string'),
	'especialidad' => array('name' => 'especialidad', 'type' => 'xsd:string'),
	'nro_historia' => array('name' => 'nro_historia', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'history_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:ahistory[]')),//the attributes of our array.
'tns:ahistory'// what type of array is this?  Oh it's an array of mytable data
);

$server->register('get_query_historial', array('id_h'=>'xsd:string','idu'=>'xsd:string'),
array('return' => 'xsd:string'),     
    'urn:wssisol',                    
    'urn:wssisol#get_query_historial',          
    'rpc',                               
    'encoded',                            
    'WS Historial de Paciente'); 

function get_query_historial($id_h,$idu){
	$cn=conectar();
	$sq="select id_dependencia,descripcion,url_dependencia,port_dependencia from hospitales where id_dependencia='".$id_h."' order by descripcion";
	$rs=pg_query($cn,$sq);
	$_cad='';
	$url=pg_fetch_result($rs,0,'url_dependencia').':'.pg_fetch_result($rs,0,'port_dependencia').'/sisol/server_soap.php';	
	$client=new nusoap_client($url);
	$param=array('idu'=>$idu);
	$response = $client->call('get_query_historial',$param);
	if($client->fault) {  
	} 
	$r=$response;  
	$ni=count($r);
	if ($ni>0){
		for ($i=0;$i<$ni;$i++){
			$_cad.="<li ><span class='file'><a href='#' onclick=\"ws_load_detalle('".$r[$i]['nro_historia']."');return false;\">".$r[$i]['fecha_atencion']."<br>".$r[$i]['especialidad']."<br>".$r[$i]['medico']."</a></span></li>";
		}
	}	
	return $_cad;
}

$server->wsdl->addComplexType(
    'product',
    'complexType',
    'struct',
    'all',
    '',
    array('id_producto' => array('name' => 'id_producto', 'type' => 'xsd:string'),'id_bus' => array('name' => 'id_bus', 'type' => 'xsd:string'),
    'items' => array('name' => 'item', 'type' => 'xsd:Array'))
);

$server->wsdl->addComplexType(
    'amsg',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'RefStatus' => array('name' => 'RefStatus', 'type' => 'xsd:string'),
	'MsgErr' => array('name' => 'MsgErr', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'msg_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:amsg[]')),//the attributes of our array.
'tns:amsg'// what type of array is this?  Oh it's an array of mytable data
);

$server->register('get_product',array('id_dep'=>'xsd:string','fec_mod'=>'xsd:string'),
 array('rsproduct' => 'xsd:Array'),     
    'urn:wssisol',                    
    'urn:wssisol#get_product',          
    'rpc',
    'encoded',
    'Web Service Productos');



$server->register('put_rotacion',               	// method name
    array('nombre'=>'xsd:string','product' => 'tns:product'),          	// input parameters
    array('return' => 'xsd:Array'),    			// output parameters
    'urn:wssisol',                         			// namespace
    'urn:wssisol#put_rotacion',                   	// soapaction
    'rpc',                                    		// style
    'encoded',                                		// use
    'Web Service Test Array');

$server->register('Execute',array('RefCenExt'=>'xsd:string',
	'RefTipDocIdeUsu'=>'xsd:string','RefNumDocIdeUsu'=>'xsd:string','RefClaveUsu'=>'xsd:string',
	'RefFecAlta'=>'xsd:string','RefTipoAlta'=>'xsd:string','RefNroComp'=>'xsd:string','RefMotAltAdm'=>'xsd:string'),
 array('return' => 'tns:msg_array'),  
    'urn:wssisol',                    
    'urn:wssisol#contrareferencia',          
    'rpc',                               
    'encoded',                            
    'Web Service Contrareferencia');


$server->register('get_packages',array('id_dep'=>'xsd:string'),
 array('rspack' => 'xsd:Array'),     
    'urn:wssisol',                    
    'urn:wssisol#get_packages',          
    'rpc',                               
    'encoded',                            
    'Web Service Paquetes'); 
	
function execute($refcenext,$reftipdocideusu,$refnumdocideusu,$refclaveusu,$reffecalta,$reftipoalta,$refnrocomp,$refmotaltadm){
	$amsg=array('Refmsg'=>array('RefStatus'=>'1','MsgErr'=>$refnrocomp));
	//$amsg['Refmsg'][0]=array();
	//$amsg[0]=array('RefStatus'=>'1','MsgErr'=>'');
	return $amsg;
}
	
	
$server->register('get_referencia_essalud',array('Refnum'=>'xsd:string','Refentext'=>'xsd:string','Reftipdocideusu'=>'xsd:string','Refnumdocideusu'=>'xsd:string',
	'Refclaveusu'=>'xsd:string'),array('refordaten' => 'xsd:Array'),  
    'urn:wssisol',                    
    'urn:wssisol#get_referencia_essalud',          
    'rpc',                               
    'encoded',                            
    'Web Service Essalud Temporal'); 
function put_rotacion($nombre,$product) {
    /*$greeting = 'Hello, ' . $person['firstname'] .
                '. It is nice to meet a ' . $person['age'] .
                ' year old ' . $person['gender'] . '.';    
    $winner = $person['firstname'] == 'Scott';
    return array(
                'greeting' => $greeting,
                'winner' => $winner
                );*/
	//$ap=array();
	//$ap['0']['CPSCod']='93000';
	$cn=conectar();
	$ins="insert into rotacion(id_producto,id_bus) values('".$product['id_producto']."','".$product['id_bus']."')";
	//$ins="insert into rotacion(id_producto,id_bus) values('".id_producto."','".$id_bus."')";
	//pg_query($cn,$ins);
	//return $nombre.$ins;
	return $product;
}


function get_referencia_essalud($refnum,$refentext,$reftipdocideusu,$refnumdocideusu,$refclaveusu){
	$ar=array();
	$ap=array();
	$ap['0']['CPSCod']='93000';
	$ap['1']['CPSCod']='93015';	
	$ap['2']['CPSCod']='93224';	
	
	$ar[0]['RefCenOrig']='A000001';
	$ar[0]['RefFecRef']='10/10/2009';
	$ar[0]['RefNum']='700629883';
	$ar[0]['RefCenDes']='00012340';
	$ar[0]['RefAreaDes']='1';
	$ar[0]['RefEspDes']='AC1';
	$ar[0]['RefActMedOrig']='0';
	$ar[0]['RefActDes']='';
	$ar[0]['RefTipDocIdePac']='1';
	$ar[0]['RefNumDocPac']='09525576';
	$ar[0]['RefApePatPac']='GUTIERREZ';
	$ar[0]['RefApeMatPac']='VILA';
	$ar[0]['RefPriNomPac']='RICARDINA ANGELICA';
	$ar[0]['RefSegNomPac']='';
	$ar[0]['RefFecNacPac']='07/06/1973';
	$ar[0]['RefSexoCodPac']='F';
	$ar[0]['RefDirDomPac']='AV LOS CEDROS MZ 2 L S/N T 7 JULIO C TEL';
	$ar[0]['RefUbiCodDom']='150119';
	$ar[0]['RefDiagOrig1']='H90.5';
	$ar[0]['RefTipDiagOrig1']='H90.5';
	$ar[0]['RefDiagOrig2']='';
	$ar[0]['RefTipDiagOrig2']='';
	$ar[0]['RefHistResumen']='';
	$ar[0]['RefComenAdic']='';
	$ar[0]['RefTipDocIdeMedOri']='1';
	$ar[0]['RefNumDocMedOri']='1';
	$ar[0]['RefCPTPres']=$ap;
	$ar[0]['RefMsgErr']='H90.5';
	return $ar;
}
function get_packages($ido){
	$cn=conectar();
	$sq="select c.id_campana,c.descripcion as campana,p.id_plantilla,p.descripcion as plantilla,p.id_convenio,e.descripcion as convenio,pro.id_producto,pro.descripcion as producto,d.precio,
		to_char(c.fec_mod,'dd/mm/yyyy HH:MI:SS AM') as fec_mod,c.estado as estado_campana,p.estado as estado_plantilla,co.descripcion as especialidad,'' as fechas,'' as tipo_rango
		from campana_master c 
		inner join plantilla_master p on c.id_campana=substring(p.id_plantilla,1,6)
		inner join det_plantilla_master d on p.id_plantilla=d.id_plantilla
		inner join productos_master pro on pro.id_producto=d.id_producto
		inner join consultorios_master co on co.id_consultorio=substring(d.id_producto,1,3)
		inner join plantillaxlocal_master pl on p.id_plantilla=pl.id_plantilla
		left join empresas e on p.id_convenio=e.id_empresa
		where pl.id_dependencia='".$ido."' order by c.fec_mod,p.id_plantilla desc";
	
	$rs=pg_query($cn,$sq);
	$ar=array();
	$nr=pg_num_rows($rs);
	$nc=pg_num_fields($rs);
	$paq='';
	for ($i=0;$i<$nr;$i++){
		for ($c=0;$c<$nc;$c++){
			$fie=pg_field_name($rs,$c);
			if ($fie<>'fechas' && $fie<>'tipo_rango') $ar[$i][$fie]=pg_fetch_result($rs,$i,$fie);
			
			if ($fie=='fechas'){
				if (pg_fetch_result($rs,$i,'id_plantilla')!=$paq){
					$paq=pg_fetch_result($rs,$i,'id_plantilla');
					$sq="select fecha_activo,tipo from plantillaxfecha_master where id_plantilla='".$paq."' and id_dependencia='".$ido."'";
					$rsf=pg_query($cn,$sq);
					$nrf=pg_num_rows($rsf);
					$in='';
					$tr='';
					if ($nrf>0){						
						for ($j=0;$j<$nrf;$j++){
							$in.=pg_fetch_result($rsf,$j,'fecha_activo').',';
							$tr=pg_fetch_result($rsf,$j,'tipo');
						}
						$in=substr($in,0,strlen($in)-1);						
					}
					$ar[$i][$fie]=$in;
					$ar[$i]['tipo_rango']=$tr;
				}
			}
			
		}
	}
	return $ar;  
	//return 'hello word';
		
}


 $server->register('upload_file',                                    // method
        array('file' => 'xsd:string','location' => 'xsd:string'),    // input parameters
        array('return' => 'xsd:string'),                             // output parameters
        'urn:uploadwsdl',                                            // namespace
        'urn:uploadwsdl#upload_file',                                // soapaction
        'rpc',                                                       // style
        'encoded',                                                   // use
        'Uploads files to the server'                                // documentation
    );

    // Define the method as a PHP function

    function upload_file($encoded,$name) {
        $location = "pdf/".$name;                               // Mention where to upload the file
        $current = file_get_contents($location);                     // Get the file content. This will create an empty file if the file does not exist     
        $current = base64_decode($encoded);                          // Now decode the content which was sent by the client     
        file_put_contents($location, $current);                      // Write the decoded content in the file mentioned at particular location      
        if($name!="")
        {
            //return "";                      // Output success message 
			return "Archivo cargado correctamente...";                      // Output success message                              
        }
        else        
        {
          	return "Porfavor Cargar un Archivo...";
			//return "";
        }
    }

function get_product($ido,$fec_max){
	$cn=conectar();
	$sq="select to_char(p.fec_mod,'dd/mm/yyyy HH:MI:SS AM') as fec_mod2,p.*,c.descripcion as consultorio,c.estado as c_estado,c.tipo as c_tipo,c.observacion as c_observacion,c.us_ing as c_us_ing,
	c.fec_ing as c_fec_ing,c.rot_tipo_prod as c_rot_tipo_prod,c.rot_alcance as c_rot_alcance,c.id_alterno as c_id_alterno 
	from productos_master p inner join consultorios_master c on substring(p.id_producto,1,3)=c.id_consultorio 
	where p.estado='1' and p.fec_mod>=to_timestamp('".$fec_max."', 'DD/MM/YYYY') 
	order by cast(substr(p.id_producto,1,3)as int),cast(substr(p.id_producto,4,7)as int)";
	$rs=pg_query($cn,$sq);
	$ar=array();
	$nr=pg_num_rows($rs);
	$nc=pg_num_fields($rs);
	$paq='';
	for ($i=0;$i<$nr;$i++){
		for ($c=0;$c<$nc;$c++){
			$fie=pg_field_name($rs,$c);
			$ar[$i][$fie]=pg_fetch_result($rs,$i,$fie);
		}
	}
	return $ar;  		
}
 $server->register('get_query_id_usuario_salud',                                    // method
        array('idu' => 'xsd:string','dep'=>'xsd:string'),    // input parameters
        array('return' => 'xsd:string'),                             // output parameters
        'urn:wssisol',                                            // namespace
        'urn:wssisol#get_query_id_usuario_salud',                                // soapaction
        'rpc',                                                       // style
        'encoded',                                                   // use
        'Query ID User Salud'                                // documentation
    );
	
function get_query_id_usuario_salud($idu,$dep){
	$cn=conectar();
	$_cad='';
	$sq="select id_dependencia,descripcion,url_dependencia,port_dependencia from hospitales where id_tipo='1' and id_dependencia not in ('".$dep."') order by descripcion";
	//$_cad=$sq;
	$rs=pg_query($cn,$sq);
	$nr=pg_num_rows($rs);
	$acen=array();
	$td=substr($idu,0,1);
	if ($td=='5'){
		$_cad='Sin documento de Identidad';
	}else{
		for ($i=0;$i<$nr;$i++){
			$url=pg_fetch_result($rs,$i,'url_dependencia').':'.pg_fetch_result($rs,$i,'port_dependencia').'/sisol/server_soap.php';
			//ini_set("default_socket_timeout", 5);
			$client=new nusoap_client($url);
			$param=array('idu'=>$idu);
			$response = $client->call('get_query_id_usuario_salud',$param);
			if($client->fault) {  
				//$_cad=$client->faultstring;
			} else{
				//$_cad=$ulr;
			}
			$r=$response;  
			if ($r=='1') {
				$_cad.="<li id='li_".pg_fetch_result($rs,$i,'id_dependencia')."' class='closed' onclick=\"load_hc('".pg_fetch_result($rs,$i,'id_dependencia')."','".$idu."');\"><span class='folder'>".pg_fetch_result($rs,$i,'descripcion')."</span>
				<ul id='ul_".pg_fetch_result($rs,$i,'id_dependencia')."'><div id='".pg_fetch_result($rs,$i,'id_dependencia')."'></div></ul></li>";
			}
		}
	}	
	return $_cad;
}

$HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
$server->service($HTTP_RAW_POST_DATA);    
?>