<?php
include('nusoap/lib/nusoap.php');
include 'clases/clinica.class.php';
$server = new nusoap_server;
$server->configureWSDL('wssisol', 'urn:wssisol');
$server->wsdl->schemaTargetNamespace='urn:wssisol';


/*Procedimientos para el envio de la atencion*/
$server->wsdl->addComplexType(
    'amsg_hc',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'err_nro' => array('name' => 'err_nro', 'type' => 'xsd:string'),
	'err_msg' => array('name' => 'err_msg', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'msg_hc_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:amsg_hc[]')),//the attributes of our array.
'tns:amsg_hc'// what type of array is this?  Oh it's an array of mytable data
);


$server->register('put_save_history',array('mode'=>'xsd:string','nro_historia'=>'xsd:string','fecha_atencion'=>'xsd:string','id_medico'=>'xsd:string',
'id_bus'=>'xsd:string','turno'=>'xsd:string','id_producto'=>'xsd:string','procedimiento'=>'xsd:string','fecha_informe'=>'xsd:string'),
array('return' => 'tns:msg_hc_array'),    			// output parameters
    'urn:wssisol',                         			// namespace
    'urn:wssisol#put_save_history',                   	// soapaction
    'rpc',                                    		// style
    'encoded',                                		// use
    'Web Service Test Array'
); 

function put_save_history($md,$nh,$fa,$cmp,$idb,$tur,$idp,$proc,$fi){
	$cn=conectar();
	$ah=array();
	
	switch ($md){
	case '1':
		/*Verificando que existe*/
		$sq="select nro_historia,anulado from tickets where nro_historia='".$nh."'";
		$rs=pg_query($cn,$sq);
		$nr=pg_num_rows($rs);
		if ($nr>0){
			/*Verificando si no esta anulado*/
			$stat=pg_fetch_result($rs,0,'anulado');
			if ($stat=='S'){
				$ah[0]=array('err_nro'=>'2','err_msg'=>'COMPROBANTE SE ENCUENTRA ANULADO');
			}else{
				/*Verificando si existe cmp y si tiene cta de usuario*/
				$sq="select id_personal from personal where id_personal='".$cmp."'";
				$rs=pg_query($cn,$sq);
				$nr=pg_num_rows($rs);
				if ($nr>0){
					/*Validando que tenga cuenta de usuario*/
					$sq="select id_us from sysaccusers where id_per='".$cmp."'";
					$rs=pg_query($cn,$sq);
					$nr=pg_num_rows($rs);
					if ($nr>0){
						$id_u=pg_fetch_result($rs,0,'id_us');
						/*Verificando si ya existe la atencion*/
						$sq="select nro_historia from cab_cie10 where nro_historia='".$nh."'";
						$rs=pg_query($cn,$sq);
						$nr=pg_num_rows($rs);
						if ($nr>0){
							$ah[0]=array('err_nro'=>'5','err_msg'=>'YA EXISTE ATENCION DEL COMPROBANTE ENVIADO');
						}else{
							/*verfificando si existe el id bus*/
							$sq="select id_bus from buses where id_bus='".$idb."'";
							$rs=pg_query($cn,$sq);
							$nr=pg_num_rows($rs);
							if ($nr>0){						
								/*saving...*/
								$sql="insert into cab_cie10(peso,talla,temperatura,peso_habitual,temp_rectal,imc,user_ins,
								nro_historia,fecha_atencion,cmp,id_bus,turno,dat_ins) values('0','0','0','0','0','0','".$id_u."','".$nh."','".$fa."','".$cmp."','".$idb."','".$tur."',now())";
								pg_query($sql);			
								$ah[0]=array('err_nro'=>'0','err_msg'=>'REGISTRO GRABADO CON EXITO');
							}else{
								$ah[0]=array('err_nro'=>'6','err_msg'=>'NO EXISTE EL CODIGO DEL CONSULTORIO');
							}
						}
						
					}else{
						$ah[0]=array('err_nro'=>'4','err_msg'=>'NO EXISTE UNA CUENTA DE USUARIO PARA ESTE PERSONAL DE SALUD');
					}				
				}else{
					$ah[0]=array('err_nro'=>'3','err_msg'=>'NO EXISTE REGISTRO DEL PERSONAL DE SALUD');
				}
			}
			
		}else{
			$ah[0]=array('err_nro'=>'1','err_msg'=>'NO EXISTE NRO_HISTORIA');
		}	
		break;
	case '2':				
		/*Verificando que existe*/
		$sq="select nro_historia from cab_cie10 where nro_historia='".$nh."'";
		$rs=pg_query($cn,$sq);
		$nr=pg_num_rows($rs);
		if ($nr>0){
			/*Buscando id producto*/
			$sq="select id_producto from productos where id_producto='".$idp."'";
			$rs=pg_query($cn,$sq);
			$nr=pg_num_rows($rs);
			if ($nr>0){
				/*Chekeando si existe el procedimiento*/
				$sq="select id_producto from det_procedure where nro_historia='".$nh."' and id_producto='".$idp."'";
				$rs=pg_query($cn,$sq);
				$nr=pg_num_rows($rs);
				if ($nr>0){
					$sql="update det_procedure set procedimiento='".$proc."',fecha_informe='".$fi."' where nro_historia='".$nh."' and id_producto='".$idp."'";
				}else{
					$sql="insert into det_procedure(nro_historia,id_producto,procedimiento,fecha_informe) values('".$nh."','".$idp."','".$proc."','".$fi."')";
				}
				pg_query($sql);
				$ah[0]=array('err_nro'=>'0','err_msg'=>'SE REGISTRO EL INFORME');
				
			}else{
				$ah[0]=array('err_nro'=>'2','err_msg'=>'ID DEL PRODUCTO NO EXISTE');
			}
				
		}else{
			$ah[0]=array('err_nro'=>'1','err_msg'=>'NO EXISTE NRO_HISTORIA');
		}		
		break;
	
	}
	
	return $ah;
}








//$server->register('get_head_invoice',array('dventa'=>'xsd:string','serie'=>'xsd:string','nro_ticket'=>'xsd:string','id_consultorio'=>'xsd:string','especialidad'=>'xsd:string','mode'=>'xsd:string')); 
$server->wsdl->addComplexType(
    'aauxiliares',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'especialidad' => array('name' => 'especialidad', 'type' => 'xsd:string'),
	'producto' => array('name' => 'producto', 'type' => 'xsd:string'),
	'cantidad' => array('name' => 'cantidad', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'auxiliares_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:aauxiliares[]')),//the attributes of our array.
'tns:aauxiliares'// what type of array is this?  Oh it's an array of mytable data
);

$server->wsdl->addComplexType(
    'adetalles',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'descripcion' => array('name' => 'descripcion', 'type' => 'xsd:string'),
	'cantidad' => array('name' => 'cantidad', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'detalles_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:adetalles[]')),//the attributes of our array.
'tns:adetalles'// what type of array is this?  Oh it's an array of mytable data
);
$server->wsdl->addComplexType(
    'acie10',
	'complexType',
	'struct',
	'all',
	'',
	array(
	'cie10' => array('name' => 'cie10', 'type' => 'xsd:string'),
	'descripcion' => array('name' => 'descripcion', 'type' => 'xsd:string'),
	'tipo' => array('name' => 'tipo', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'cie10_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:acie10[]')),//the attributes of our array.
'tns:acie10'// what type of array is this?  Oh it's an array of mytable data
);

$server->wsdl->addComplexType(
    'amain_hc',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'peso' => array('name' => 'peso', 'type' => 'xsd:string'),
	'talla' => array('name' => 'talla', 'type' => 'xsd:string'),
	'presion_art' => array('name' => 'presion_art', 'type' => 'xsd:string'),
	'frecuencia_car' => array('name' => 'frecuencia_car', 'type' => 'xsd:string'),
	'frecuencia_res' => array('name' => 'frecuencia_res', 'type' => 'xsd:string'),
	'temperatura' => array('name' => 'temperatura', 'type' => 'xsd:string'),
	'motivo' => array('name' => 'motivo', 'type' => 'xsd:string'),
	'tratamiento' => array('name' => 'tratamiento', 'type' => 'xsd:string'),
	'relato_enf' => array('name' => 'relato_enf', 'type' => 'xsd:string'),
	'examen_c_g' => array('name' => 'examen_c_g', 'type' => 'xsd:string'),	
	'tiempo_enf' => array('name' => 'tiempo_enf', 'type' => 'xsd:string'),
	'inicio_enf' => array('name' => 'inicio_enf', 'type' => 'xsd:string'),
	'curso_enf' => array('name' => 'curso_enf', 'type' => 'xsd:string'),	
	'adetalles' => array('name' => 'adetalles', 'type' => 'tns:detalles_array'),
	'acie10' => array('name' => 'acie10', 'type' => 'tns:cie10_array'),
	'aauxiliares' => array('name' => 'aauxiliares', 'type' => 'tns:auxiliares_array')
	)
);
$server->wsdl->addComplexType(
'main_hc_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:amain_hc[]')),//the attributes of our array.
'tns:amain_hc'// what type of array is this?  Oh it's an array of mytable data
);
$server->register('get_main_hc', array('nro_historia'=>'xsd:string'),
array('return' => 'tns:main_hc_array'),     
    'urn:wssisol',                    
    'urn:wssisol#get_main_hc',          
    'rpc',                               
    'encoded',                            
    'WS Detalle de Historia Clinica'); 


function get_main_hc($hc){
	$cn=conectar();
	$adetalles=array();
	$acie10=array();
	$aaux=array();
	$sq="select peso,talla,presion_art,frecuencia_car,frecuencia_res,temperatura,motivo,tratamiento,relato_enf,examen_c_g,tiempo_enf,inicio_enf,curso_enf from cab_cie10 where nro_historia='".$hc."'";
	$rscb=pg_query($cn,$sq);
	
	$sq="select p.descripcion,d.cantidad from detalles d inner join productos p on d.id_producto=p.id_producto where d.nro_historia='".$hc."'";
	$rsdt=pg_query($cn,$sq);
	$nr=pg_num_rows($rsdt);
	for ($i=0;$i<$nr;$i++){
		$adetalles[$i]=array(
			'descripcion'=>pg_fetch_result($rsdt,$i,'descripcion'),
			'cantidad'=>pg_fetch_result($rsdt,$i,'cantidad')
		);
	}
	
	$sq="select d.cie10,d.tipo,cie.descripcion from det_cie10 d inner join cie10 cie on d.cie10=cie.cie10 where d.nro_historia='".$hc."'";
	$rscie=pg_query($cn,$sq);
	$nr=pg_num_rows($rscie);
	for ($i=0;$i<$nr;$i++){
		$acie10[$i]=array(
			'cie10'=>pg_fetch_result($rscie,$i,'cie10'),
			'descripcion'=>pg_fetch_result($rscie,$i,'descripcion'),
			'tipo'=>pg_fetch_result($rscie,$i,'tipo')
		);
	}
	
	$sq="select c.descripcion as especialidad,p.descripcion as producto,aux.cantidad from det_aux aux inner join 
	     productos p on aux.id_producto=p.id_producto inner join consultorios c on c.id_consultorio=substring(p.id_producto,1,6) where  aux.nro_historia='".$hc."'";
	$rsaux=pg_query($cn,$sq);
	$nr=pg_num_rows($rsaux);
	for ($i=0;$i<$nr;$i++){
		$aaux[$i]=array(
			'especialidad'=>pg_fetch_result($rsaux,$i,'especialidad'),
			'producto'=>pg_fetch_result($rsaux,$i,'producto'),
			'cantidad'=>pg_fetch_result($rsaux,$i,'cantidad')
		);
	}		
	
	$ah=array();
	$ah[0]=array(
	'peso'=>pg_fetch_result($rscb,0,'peso'),
	'talla'=>pg_fetch_result($rscb,0,'talla'),
	'presion_art'=>pg_fetch_result($rscb,0,'presion_art'),
	'frecuencia_car'=>pg_fetch_result($rscb,0,'frecuencia_car'),
	'frecuencia_res'=>pg_fetch_result($rscb,0,'frecuencia_res'),
	'temperatura'=>pg_fetch_result($rscb,0,'temperatura'),
	'motivo'=>pg_fetch_result($rscb,0,'motivo'),
	'tratamiento'=>pg_fetch_result($rscb,0,'tratamiento'),
	'relato_enf'=>pg_fetch_result($rscb,0,'relato_enf'),
	'examen_c_g'=>pg_fetch_result($rscb,0,'examen_c_g'),
	'tiempo_enf'=>pg_fetch_result($rscb,0,'tiempo_enf'),
	'inicio_enf'=>pg_fetch_result($rscb,0,'inicio_enf'),
	'curso_enf'=>pg_fetch_result($rscb,0,'curso_enf'),
	'adetalles'=>$adetalles,
	'acie10'=>$acie10,
	'aauxiliares'=>$aaux
	);
	
	return $ah;
}

$server->wsdl->addComplexType(
    'ahistory',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'fecha_atencion' => array('name' => 'fecha_atencion', 'type' => 'xsd:string'),
	'medico' => array('name' => 'medico', 'type' => 'xsd:string'),
	'comprobante' => array('name' => 'comprobante', 'type' => 'xsd:string'),
	'especialidad' => array('name' => 'especialidad', 'type' => 'xsd:string'),
	'nro_historia' => array('name' => 'nro_historia', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'history_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:ahistory[]')),//the attributes of our array.
'tns:ahistory'// what type of array is this?  Oh it's an array of mytable data
);

$server->register('get_query_historial', array('idu'=>'xsd:string'),
array('return' => 'tns:history_array'),     
    'urn:wssisol',                    
    'urn:wssisol#get_query_historial',          
    'rpc',                               
    'encoded',                            
    'WS Historial de Paciente'); 

function get_query_historial($idu){
	$cn=conectar();
	$sq="select cb.nro_historia,to_char(cb.fecha_atencion,'dd/mm/yyyy')  as fecha_atencion,(td.val_abr||' '||t.serie||'-'||t.nro_ticket) as comprobante,
	(m.ape_paterno||' '||m.ape_materno||', '||m.nombres) as medico,c.descripcion as especialidad from tickets t 
	inner join cab_cie10 cb on cb.nro_historia=t.nro_historia
	inner join consultorios c on t.id_consultorio=c.id_consultorio
	inner join personal m on cb.cmp=m.id_personal
	inner join tablatipo td on t.dventa=td.id_tipo and td.id_tabla='10'
	inner join pacientes p on t.id_paciente=p.id_paciente where p.id_usuario_salud='".$idu."' order by cb.fecha_atencion";
	$rs=pg_query($cn,$sq);
	$nr=pg_num_rows($rs);
	$ah=array();
	for ($i=0;$i<$nr;$i++){
		$ah[$i]=array('fecha_atencion'=>pg_fetch_result($rs,$i,'fecha_atencion'),'medico'=>pg_fetch_result($rs,$i,'medico'),
			'comprobante'=>pg_fetch_result($rs,$i,'comprobante'),'especialidad'=>pg_fetch_result($rs,$i,'especialidad'),'nro_historia'=>pg_fetch_result($rs,$i,'nro_historia'));
	}
	return $ah;
}


$server->wsdl->addComplexType(
    'product',
    'complexType',
    'struct',
    'all',
    '',
    array('id_producto' => array('name' => 'id_producto', 'type' => 'xsd:string'),'id_bus' => array('name' => 'id_bus', 'type' => 'xsd:string'),
    'items' => array('name' => 'item', 'type' => 'xsd:Array'))
);

$server->wsdl->addComplexType(
    'amsg',
    'complexType',
    'struct',
    'all',
    '',
    array(
	'RefStatus' => array('name' => 'RefStatus', 'type' => 'xsd:string'),
	'MsgErr' => array('name' => 'MsgErr', 'type' => 'xsd:string')
	)
);
$server->wsdl->addComplexType(
'msg_array',//glorious name
'complexType',// not a simpletype for sure!
'array',// oh we are an array now!
'',// bah. blank
'SOAP-ENC:Array',
array(),// our element is an array.
array(array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:amsg[]')),//the attributes of our array.
'tns:amsg'// what type of array is this?  Oh it's an array of mytable data
);

$server->register('get_product',array('id_dep'=>'xsd:string','fec_mod'=>'xsd:string'),
 array('rsproduct' => 'xsd:Array'),     
    'urn:wssisol',                    
    'urn:wssisol#get_product',          
    'rpc',
    'encoded',
    'Web Service Productos');



$server->register('put_rotacion',               	// method name
    array('nombre'=>'xsd:string','product' => 'tns:product'),          	// input parameters
    array('return' => 'xsd:Array'),    			// output parameters
    'urn:wssisol',                         			// namespace
    'urn:wssisol#put_rotacion',                   	// soapaction
    'rpc',                                    		// style
    'encoded',                                		// use
    'Web Service Test Array');

$server->register('Execute',array('RefCenExt'=>'xsd:string',
	'RefTipDocIdeUsu'=>'xsd:string','RefNumDocIdeUsu'=>'xsd:string','RefClaveUsu'=>'xsd:string',
	'RefFecAlta'=>'xsd:string','RefTipoAlta'=>'xsd:string','RefNroComp'=>'xsd:string','RefMotAltAdm'=>'xsd:string'),
 array('return' => 'tns:msg_array'),  
    'urn:wssisol',                    
    'urn:wssisol#contrareferencia',          
    'rpc',                               
    'encoded',                            
    'Web Service Contrareferencia');


$server->register('get_packages',array('id_dep'=>'xsd:string'),
 array('rspack' => 'xsd:Array'),     
    'urn:wssisol',                    
    'urn:wssisol#get_packages',          
    'rpc',                               
    'encoded',                            
    'Web Service Paquetes'); 
	
function execute($refcenext,$reftipdocideusu,$refnumdocideusu,$refclaveusu,$reffecalta,$reftipoalta,$refnrocomp,$refmotaltadm){
	$amsg=array('Refmsg'=>array('RefStatus'=>'1','MsgErr'=>$refnrocomp));
	//$amsg['Refmsg'][0]=array();
	//$amsg[0]=array('RefStatus'=>'1','MsgErr'=>'');
	return $amsg;
}
	
	
$server->register('get_referencia_essalud',array('Refnum'=>'xsd:string','Refentext'=>'xsd:string','Reftipdocideusu'=>'xsd:string','Refnumdocideusu'=>'xsd:string',
	'Refclaveusu'=>'xsd:string'),array('refordaten' => 'xsd:Array'),  
    'urn:wssisol',                    
    'urn:wssisol#get_referencia_essalud',          
    'rpc',                               
    'encoded',                            
    'Web Service Essalud Temporal'); 
function put_rotacion($nombre,$product) {
    /*$greeting = 'Hello, ' . $person['firstname'] .
                '. It is nice to meet a ' . $person['age'] .
                ' year old ' . $person['gender'] . '.';    
    $winner = $person['firstname'] == 'Scott';
    return array(
                'greeting' => $greeting,
                'winner' => $winner
                );*/
	//$ap=array();
	//$ap['0']['CPSCod']='93000';
	$cn=conectar();
	$ins="insert into rotacion(id_producto,id_bus) values('".$product['id_producto']."','".$product['id_bus']."')";
	//$ins="insert into rotacion(id_producto,id_bus) values('".id_producto."','".$id_bus."')";
	//pg_query($cn,$ins);
	//return $nombre.$ins;
	return $product;
}


function get_referencia_essalud($refnum,$refentext,$reftipdocideusu,$refnumdocideusu,$refclaveusu){
	$ar=array();
	$ap=array();
	$ap['0']['CPSCod']='93000';
	$ap['1']['CPSCod']='93015';	
	$ap['2']['CPSCod']='93224';	
	
	$ar[0]['RefCenOrig']='A000001';
	$ar[0]['RefFecRef']='10/10/2009';
	$ar[0]['RefNum']='700629883';
	$ar[0]['RefCenDes']='00012340';
	$ar[0]['RefAreaDes']='1';
	$ar[0]['RefEspDes']='AC1';
	$ar[0]['RefActMedOrig']='0';
	$ar[0]['RefActDes']='';
	$ar[0]['RefTipDocIdePac']='1';
	$ar[0]['RefNumDocPac']='09525576';
	$ar[0]['RefApePatPac']='GUTIERREZ';
	$ar[0]['RefApeMatPac']='VILA';
	$ar[0]['RefPriNomPac']='RICARDINA ANGELICA';
	$ar[0]['RefSegNomPac']='';
	$ar[0]['RefFecNacPac']='07/06/1973';
	$ar[0]['RefSexoCodPac']='F';
	$ar[0]['RefDirDomPac']='AV LOS CEDROS MZ 2 L S/N T 7 JULIO C TEL';
	$ar[0]['RefUbiCodDom']='150119';
	$ar[0]['RefDiagOrig1']='H90.5';
	$ar[0]['RefTipDiagOrig1']='H90.5';
	$ar[0]['RefDiagOrig2']='';
	$ar[0]['RefTipDiagOrig2']='';
	$ar[0]['RefHistResumen']='';
	$ar[0]['RefComenAdic']='';
	$ar[0]['RefTipDocIdeMedOri']='1';
	$ar[0]['RefNumDocMedOri']='1';
	$ar[0]['RefCPTPres']=$ap;
	$ar[0]['RefMsgErr']='H90.5';
	return $ar;
}
function get_packages($ido){
	$cn=conectar();
	$sq="select c.id_campana,c.descripcion as campana,p.id_plantilla,p.descripcion as plantilla,p.id_convenio,e.descripcion as convenio,pro.id_producto,pro.descripcion as producto,d.precio,
		to_char(c.fec_mod,'dd/mm/yyyy HH:MI:SS AM') as fec_mod,c.estado as estado_campana,p.estado as estado_plantilla,co.descripcion as especialidad,'' as fechas,'' as tipo_rango
		from campana_master c 
		inner join plantilla_master p on c.id_campana=substring(p.id_plantilla,1,6)
		inner join det_plantilla_master d on p.id_plantilla=d.id_plantilla
		inner join productos_master pro on pro.id_producto=d.id_producto
		inner join consultorios_master co on co.id_consultorio=substring(d.id_producto,1,3)
		inner join plantillaxlocal_master pl on p.id_plantilla=pl.id_plantilla
		left join empresas e on p.id_convenio=e.id_empresa
		where pl.id_dependencia='".$ido."' order by c.fec_mod,p.id_plantilla desc";
	
	$rs=pg_query($cn,$sq);
	$ar=array();
	$nr=pg_num_rows($rs);
	$nc=pg_num_fields($rs);
	$paq='';
	for ($i=0;$i<$nr;$i++){
		for ($c=0;$c<$nc;$c++){
			$fie=pg_field_name($rs,$c);
			if ($fie<>'fechas' && $fie<>'tipo_rango') $ar[$i][$fie]=pg_fetch_result($rs,$i,$fie);
			
			if ($fie=='fechas'){
				if (pg_fetch_result($rs,$i,'id_plantilla')!=$paq){
					$paq=pg_fetch_result($rs,$i,'id_plantilla');
					$sq="select fecha_activo,tipo from plantillaxfecha_master where id_plantilla='".$paq."' and id_dependencia='".$ido."'";
					$rsf=pg_query($cn,$sq);
					$nrf=pg_num_rows($rsf);
					$in='';
					$tr='';
					if ($nrf>0){						
						for ($j=0;$j<$nrf;$j++){
							$in.=pg_fetch_result($rsf,$j,'fecha_activo').',';
							$tr=pg_fetch_result($rsf,$j,'tipo');
						}
						$in=substr($in,0,strlen($in)-1);						
					}
					$ar[$i][$fie]=$in;
					$ar[$i]['tipo_rango']=$tr;
				}
			}
			
		}
	}
	return $ar;  
	//return 'hello word';
		
}

/*function get_head_invoice($dv,$ser,$nr,$idc,$esp,$mod)  
{  
	$cn = conectar();
	if ($mod=='1'){
		$chr="select t.nro_ticket,t.serie,t.nro_historia,to_char(t.fecha_emision,'dd/mm/yyyy') as fecha_emision,t.id_paciente,t.dventa,t.moneda,
			p.ape_paterno,p.ape_materno,p.nombre,substring(id_usuario_salud,2,8) as dni,p.edad,p.fecha_nac,p.sexo,p.asegurado,p.e_mail,p.odoc,p.telefono,
			p.direccion,u.distrito,p.id_distrito,t.forpago
			from tickets t 
			inner join pacientes p on t.id_paciente=p.id_paciente
			left join ubigeo2005 u on p.id_distrito=u.ubigeo
			inner join consultorios c on t.id_consultorio=c.id_consultorio
			where t.anulado<>'S' and t.dventa='".$dv."' and t.serie='".$ser."' and t.nro_ticket='".$nr."'
			and (t.id_consultorio='".$idc."' and or c.descripcion like '%".$esp."%' )
			order by t.fecha_emision,t.serie,t.nro_ticket";
	} else {
		$chr="select p.descripcion as producto,d.id_producto,d.cantidad,d.dscto,d.monto,((d.monto-d.dscto)*d.cantidad) as subtotal from detalles d
			inner join tickets t on d.nro_historia=t.nro_historia inner join productos p on d.id_producto=p.id_producto 
			inner join consultorios c on t.id_consultorio=c.id_consultorio
			where t.anulado<>'S' and t.serie='".$ser."' and t.nro_ticket='".$nr."' and t.dventa='".$dv."'
			and (t.id_consultorio='".$idc."' and or c.descripcion like '%".$esp."%' ) ";
	}
	
  	$rs=pg_query($cn,$chr);
	$ar=array();
	$nr=pg_num_rows($rs);
	$nc=pg_num_fields($rs);
	for ($i=0;$i<$nr;$i++){
		for ($c=0;$c<$nc;$c++){
			$fie=pg_field_name($rs,$c);
			$ar[$i][$fie]=pg_fetch_result($rs,$i,$fie);
		}
	}
	return $ar;  
} */ 










 $server->register('upload_file',                                    // method
        array('file' => 'xsd:string','location' => 'xsd:string'),    // input parameters
        array('return' => 'xsd:string'),                             // output parameters
        'urn:uploadwsdl',                                            // namespace
        'urn:uploadwsdl#upload_file',                                // soapaction
        'rpc',                                                       // style
        'encoded',                                                   // use
        'Uploads files to the server'                                // documentation
    );

    // Define the method as a PHP function

    function upload_file($encoded,$name) {
        $location = "uploads/".$name;                               // Mention where to upload the file
        $current = file_get_contents($location);                     // Get the file content. This will create an empty file if the file does not exist     
        $current = base64_decode($encoded);                          // Now decode the content which was sent by the client     
        file_put_contents($location, $current);                      // Write the decoded content in the file mentioned at particular location      
        if($name!="")
        {
            return "";                      // Output success message 
			//return "Archivo cargado correctamente...";                      // Output success message                              
        }
        else        
        {
          //  return "Porfavor Cargar un Archivo...";
			return "";
        }
    }

function get_product($ido,$fec_max){
	$cn=conectar();
	$sq="select to_char(p.fec_mod,'dd/mm/yyyy HH:MI:SS AM') as fec_mod2,p.*,c.descripcion as consultorio,c.estado as c_estado,c.tipo as c_tipo,c.observacion as c_observacion,c.us_ing as c_us_ing,
	c.fec_ing as c_fec_ing,c.rot_tipo_prod as c_rot_tipo_prod,c.rot_alcance as c_rot_alcance,c.id_alterno as c_id_alterno 
	from productos_master p inner join consultorios_master c on substring(p.id_producto,1,3)=c.id_consultorio 
	where p.estado='1' and p.fec_mod>=to_timestamp('".$fec_max."', 'DD/MM/YYYY') 
	order by cast(substr(p.id_producto,1,3)as int),cast(substr(p.id_producto,4,7)as int)";
	$rs=pg_query($cn,$sq);
	$ar=array();
	$nr=pg_num_rows($rs);
	$nc=pg_num_fields($rs);
	$paq='';
	for ($i=0;$i<$nr;$i++){
		for ($c=0;$c<$nc;$c++){
			$fie=pg_field_name($rs,$c);
			$ar[$i][$fie]=pg_fetch_result($rs,$i,$fie);
		}
	}
	return $ar;  		
}
$server->register('get_query_id_usuario_salud',                                    // method
        array('idu' => 'xsd:string'),    // input parameters
        array('return' => 'xsd:string'),                             // output parameters
        'urn:wssisol',                                            // namespace
        'urn:wssisol#get_query_id_usuario_salud',                                // soapaction
        'rpc',                                                       // style
        'encoded',                                                   // use
        'Query ID User Salud'                                // documentation
);

$server->register('get_format_ticket',                                    // method
        array('ip' => 'xsd:string','ope'=>'xsd:string','nro_historia'=>'xsd:string','dventa'=>'xsd:string','id_usuario'=>'xsd:string'),    // input parameters
        array('return' => 'xsd:string'),                             // output parameters
        'urn:wssisol',                                            // namespace
        'urn:wssisol#get_format_ticket',                                // soapaction
        'rpc',                                                       // style
        'encoded',                                                   // use
        'Print Ticket'                                // documentation
);

function get_format_ticket($ip,$ope,$nro_historia,$dventa,$id_usuario){
	$cn=conectar();
	$sql="select * from entorno";
	$rse=pg_query($cn,$sql);
	$raz=pg_fetch_result($rse,0,'razon_social');
	$nruc='RUC: '.pg_fetch_result($rse,0,'ruc');
	$foo=pg_fetch_result($rse,0,'ticket_footer_message');
	$sql="select o.descripcion,o.direccion,u.distrito,u.provincia from operativo o left join ubigeo2005 u on o.id_distrito=u.ubigeo where o.id_oper='$ope'";
	$rso=pg_query($cn,$sql);
	$pto=pg_fetch_result($rso,0,'descripcion');
	$dir=pg_fetch_result($rso,0,'direccion').' - '.pg_fetch_result($rso,0,'distrito').' - '.pg_fetch_result($rso,0,'provincia');
	$nhc=$nro_historia; 
	$cad="select to_char(t.fecha_emision,'dd/mm/yyyy HH12:MI:SS AM') as fecha_emision,t.porigv,s.key_pass as cajero,pri.descripcion as serial,
		t.efectivo,t.vuelto,td.val_abr,t.serie,t.nro_ticket,cli.nombres as razon,cli.ruc,con.descripcion as consultorio,t.id_consultorio,t.fecha_emision as fecha_emi,
		p.ape_paterno,p.ape_materno,p.nombre,p.id_usuario_salud as dni,t.forpago,t.moneda,t.total_dscto,
		(pe.nombres||' '||pe.ape_paterno||' '||pe.ape_materno) as autoriza,fp.descripcion as forma,
		(p.edad||' a. '||p.edad_meses||' m. '||p.edad_dias|| 'd.') as edad,t.id_paciente,t.num_ref_essalud,t.cen_ori_essalud,
		cam.descripcion as campana,paq.descripcion as paquete
		from tickets t 
		inner join pacientes p on t.id_paciente=p.id_paciente
		left join tablatipo td on substring(p.id_usuario_salud,1,1)=td.id_tipo and td.id_tabla='9'
		left join tablatipo fp on fp.id_tipo=t.forpago and fp.id_tabla='12'
		left join personal pe on t.id_personal_dscto=pe.id_personal
		left join clientes cli on cli.id_cliente=t.id_cliente
		left join campana cam on substring(t.id_paquete,1,6)=cam.id_campana
		left join plantilla paq on t.id_paquete=paq.id_plantilla
		inner join consultorios con on t.id_consultorio=con.id_consultorio
		inner join sysaccusers s on t.digitador=s.id_us 
		inner join serialxhost sh on t.serie=sh.serie and t.dventa=sh.dventa 
		inner join tablatipo pri on sh.serial_ticketera=pri.id_tipo and pri.id_tabla='67'
		where nro_historia='$nhc'";
	$rs_t=pg_query($cn,$cad);
	$fecha_emi=pg_fetch_result($rs_t,0,'fecha_emision');
	$_dat=substr($fecha_emi,0,10);
	$_hor=substr($fecha_emi,11,13);
	$porigv=number_format(pg_fetch_result($rs_t,0,'porigv'),0,'','');
	$nsp_raz=(40-strlen($raz))/2;
	$nsp_pto=(40-strlen($pto))/2;
	$nsp_dir=(40-strlen($dir))/2;
	
	$tag='';
	$_id=pg_fetch_result($rs_t,0,'id_paciente');
	/*Chocolateado*/
	$sq="select b.bus as tag_rot from tickets t inner join buses b on t.id_bus=b.id_bus where t.nro_historia='".$nhc."'";
	$_rs=pg_query($cn,$sq);
	$_nr=pg_num_rows($_rs);
	$lok='';
	
	$hoy="select to_char(now(),'dd/mm/yyyy') as hoy";
	$rshoy=pg_query($cn,$hoy);
	$hoy=pg_fetch_result($rshoy,0,'hoy');
	
	
	if ($_nr>0){ $tag=pg_fetch_result($_rs,0,'tag_rot'); }
	if ($tag==''){	
		$rot="select c.id_consultorio,c.rot_tipo_prod,c.rot_alcance from tickets t left join consultorios c on t.id_consultorio=c.id_consultorio where t.nro_historia='".$nhc."'";
		$rs=pg_query($cn,$rot);
		$t_rot=pg_fetch_result($rs,0,'rot_tipo_prod'); $t_alc=pg_fetch_result($rs,0,'rot_alcance'); $i_esp=pg_fetch_result($rs,0,'id_consultorio');
		if ($t_rot<>''){
			if ($t_rot=='*'){ 
				if ($t_alc=='N'){  
					$sq="select count(*) as cantidad from tickets where id_paciente='".$_id."' and id_consultorio='".$i_esp."'";				
					$ds=pg_query($cn,$sq); $na=pg_num_rows($ds);
					if ($na>0){
						if (pg_fetch_result($ds,0,'cantidad')=='1'){
							$lok='S';							
						}
					}
				}else{ 
					$lok='S';
				}					
			}else{ 
				$cad="select p.id_producto from detalles  d inner join productos p on d.id_producto=p.id_producto inner join tablatipo t on p.tipo=t.id_tipo and t.id_tabla='5' where p.tipo in ('".$t_rot."') and nro_historia='$nhc'";
				$rs=pg_query($cn,$cad); $nr=pg_num_rows($rs);
				if ($nr>0){ 
					if ($t_alc=='N'){  
						$sq="select count(*) as cantidad from tickets where id_paciente='".$_id."' and id_consultorio='".$i_esp."'";
						$ds=pg_query($cn,$sq); $na=pg_num_rows($ds);
						if ($na>0){
							if (pg_fetch_result($ds,0,'cantidad')=='1'){	
								$lok='S';	
							}
						}					
					}else{ 
						$lok='S';
					}
				}
			}	
		} 
	}
	if ($lok=='S'){
		$sq="select x.id_bus,x.bus,sum(x.cantidad) as cantidad from (select id_bus,bus, 0 as cantidad from buses where inc_rot='1' 
		and substring(id_bus,1,6)='".$i_esp."' union all select b.id_bus,b.bus,count(t.*) as cantidad from tickets t inner join buses b on t.id_bus=b.id_bus where b.inc_rot='1' and t.fecha_emision>='".$hoy." 12:00 am' and substring(b.id_bus,1,6)='".$i_esp."' group by b.id_bus,b.bus)x group by x.id_bus,x.bus order by 3 ";
		$rs=pg_query($cn,$sq); $nr=pg_num_rows($rs);
		if ($nr>0){ 
			$up="update tickets set id_bus='".pg_fetch_result($rs,0,'id_bus')."' where nro_historia='".$nhc."'";
			pg_query($cn,$up); $tag=pg_fetch_result($rs,0,'bus');
		}
	}
	
	$cv=$dventa;
	$ncopys=1;
	switch ($cv) {
		case 1:
			$td='FACTURA';
			break;
		case 2:
			$td='BOLETA DE VENTA';
			break;
		case 3:
			$td='RECIBO DE CAJA';
			break;
		case 5:
			$td='TICKET BOLETA';
			break;
		case 6:
			$td='TICKET FACTURA';
			if (pg_fetch_result($rse,0,'ldoubletf')=='1'){
				$ncopys=2;
			}		
			break;			
	}
	
	
}


	
function get_query_id_usuario_salud($idu){
	$ok='0';
	$cn=conectar();
	$sq="select id_usuario_salud from pacientes where id_usuario_salud='".$idu."'";
	$rs=pg_query($cn,$sq);
	$nr=pg_num_rows($rs);
	if ($nr>0){
		$ok='1';
	}
	return $ok;
}

$HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
$server->service($HTTP_RAW_POST_DATA);    
?>