<?
include 'clases/clinica.class.php';
require('fpdf.php');
session_start();
if (!isset($_SESSION["accessauthority"])){
	header("location:index.php");
	exit();
}


class PDF extends FPDF
{
	//Cabecera de página
	function Header()
	{
		$this->Image('imagenes/head_logo_hc.jpg',6,6,198,20);
		$this->SetY(20);
		$ti='ATENCION DE SALUD';
		$dat=date('d/m/Y');
		//Título
		$this->SetFont('Arial','B',11);		
		$this->SetTextColor(128,128,128);
		$this->Cell(198,9,$_SESSION['operativo'],0,1,'R');	
		$this->SetTextColor(0,0,0);		

		$this->SetFont('Arial','UB',12);
		$this->Cell(210,6,$ti,0,1,'C');				
		$this->SetFont('Arial','',8);
		$this->SetDrawColor(128,128,128);
		$this->SetFont('Arial','',8);
		$this->Cell(0,4,'N Historia: '.$_SESSION['s_dni'],0,1,'R');
		$this->Cell(0,4,$_SESSION['s_invoice'],0,1,'R');
		
	}
	function Footer()
	{
		$this->SetY(-8);
		$this->SetFont('Courier','',7);
		if (!empty($_SESSION['s_firma'])){
			$this->Image($_SESSION['s_firma'],146,270,50,16);
			$this->SetX(140);
			$this->Cell(0,2,str_repeat('-',30),0,1,'C');
			$this->SetX(140);
			$this->Cell(0,3,$_SESSION['s_completo'],0,1,'C');
		}
		/*$this->SetX(140);
		$this->Cell(0,3,$_SESSION['s_cargo'],0,1,'C');*/
	}
	
}
$pdf=new PDF('P','mm','A4');
$pdf->SetAutoPageBreak(true,26);
$pdf->SetMargins(6,6,6);
$pdf->AliasNbPages();

$cn=conectar();
$cad="select t.nro_historia,p.id_paciente,p.nombre,p.ape_paterno,p.ape_materno,ti.val_abr as tipodoc,p.id_usuario_salud as dni,
		p.fecha_nac,(t.edad||' a. '||t.edad_meses||' m. '||t.edad_dias||' d.') as edad,p.sexo,p.telefono,
		t.id_consultorio,c.descripcion as consultorio,t.serie,t.nro_ticket,to_char(t.fecha_emision,'dd/mm/yyyy HH:MI AM') as fecha_emision,cb.cmp,
		(p.ape_paterno || ' ' || p.ape_materno || ', ' || p.nombre)as paciente,to_char(cb.fecha_atencion,'dd/mm/yyyy HH:MI AM') as fecha_atencion,
		tu.descripcion as turno,(me.ape_paterno || ' ' || me.ape_materno || ', ' || me.nombres)as medico,bu.bus,substring(me.tncol,2,8) as tncol,					  
		td.descripcion as tipodocumento,s.key_pass as digitador,cb.tiempo_enf,cb.inicio_enf,cb.curso_enf,cb.relato_enf,cb.ant_pat,cb.ant_qx,cb.ant_ale,cb.ant_fam,cb.ant_epi,cb.ant_otros,
		cb.peso,cb.talla,cb.presion_art,cb.frecuencia_car,cb.frecuencia_res,cb.temperatura,cb.examen_c_g,cb.examen_c_e,
		hg.fur_ant,hg.fur_act,hg.paridad,hg.tipo_parto,hg.fec_aborto,hg.causa_aborto,hg.pin,hg.irs,hg.n_par_sex,hg.pap_ant,hg.result_pap_ant,hg.mac_tipo,hg.tip_consulta,hg.especuloscopia,cb.tratamiento,
		ant_epi_lug,ant_epi_otr,ant_fis_ali,ant_fis_sed,ant_fis_diu,ant_fis_cat,ant_fis_sue,ant_fis_otr,peso_habitual,temp_rectal,
		imc,nutricional,hidratacion,piel,cabeza,torax,mamas,respiratorio,cardiovascular,pelvis,obstetrico,genito,
		nervioso,osteo,motivo,dieta,interconsulta,proxima_cita,cb.id_per,fp.descripcion as forma_pago,
		fa.nombre as nombre_f,fa.ape_paterno as ape_paterno_f,fa.ape_materno as ape_materno_f,par.descripcion as parentesco_f,substring(fa.id_usuario_salud,2,8) as dni_f
		
		from tickets t 
		inner join consultorios c on t.id_consultorio=c.id_consultorio
		inner join tablatipo td on t.dventa=td.id_tipo and td.id_tabla='10'
		inner join tablatipo fp on t.forpago=fp.id_tipo and fp.id_tabla='12'
		left join pacientes p on t.id_paciente=p.id_paciente	
		inner join tablatipo ti on substring(p.id_usuario_salud,1,1)=ti.id_tipo and ti.id_tabla='9'
		left join ubigeo2005 u on p.id_distrito=u.id_old	
		inner join sysaccusers s on t.digitador=s.id_us 
		left join cab_cie10 cb on t.nro_historia=cb.nro_historia
		left join tablatipo tu on cb.turno=tu.id_tipo and tu.id_tabla='7'
		left join pacientes fa on t.id_titular=fa.id_paciente
		left join tablatipo par on t.id_parentesco=par.id_tipo and par.id_tabla='32'
		left join sysaccusers ui on cb.user_ins=ui.id_us 
		left join sysaccusers um on cb.user_upd=um.id_us 
		left join hc_ginecologia hg on t.nro_historia=hg.nro_historia
		left join personal me on cb.cmp=me.id_personal
		left join buses bu on cb.id_bus=bu.id_bus where t.nro_historia='".$_GET['hc']."'";
$rsate=pg_query($cn,$cad);

if (isset($_GET['firma'])){	
	$sq="select p.file_signature from sysaccusers u inner join personal p on p.id_personal=u.id_per 
		where u.id_us='".$_SESSION['usr_id']."' ";
	$rsfir=pg_query($cn,$sq);
	
	$fir=pg_fetch_result($rsfir,0,'file_signature');
	if (!empty($fir)) $_SESSION['s_firma']='uploads/firmas/'.$fir; else $_SESSION['s_firma']='';
}else{
	$_SESSION['s_firma']='';
}

$_SESSION['s_dni']=substr(pg_fetch_result($rsate,0,'dni'),1,8);
$_SESSION['s_invoice']=ucwords(strtolower(pg_fetch_result($rsate,0,'tipodocumento'))).': '.pg_fetch_result($rsate,0,'serie').'-'.pg_fetch_result($rsate,0,'nro_ticket');

$pdf->AddPage();

//$pdf->Cell(198,4,'N Historia: '.substr(pg_fetch_result($rsate,0,'dni'),1,8),0,1,'R');
//$pdf->Cell(198,4,ucwords(strtolower(pg_fetch_result($rsate,0,'tipodocumento'))).': '.pg_fetch_result($rsate,0,'serie').'-'.pg_fetch_result($rsate,0,'nro_ticket'),0,1,'R');

$pdf->SetFont('Arial','BI',8);
$pdf->Cell(4,5,'1. ',0,0,'');
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(40,5,'FILIACION',0,1,'');
$pdf->SetFont('Arial','',8);
$pdf->SetX(10);
$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(82,4,'Nombres y Apellidos','LTBR',0,'C',true);
$pdf->Cell(28,4,'Paciente','LTBR',0,'C',true);
$pdf->Cell(20,4,pg_fetch_result($rsate,0,'tipodoc'),'LTBR',0,'C',true);
$pdf->Cell(10,4,'Sexo','LTBR',0,'C',true);
$pdf->Cell(24,4,'Edad','LTBR',0,'C',true);
$pdf->Cell(30,4,'Fecha Hora Atencion','LTBR',1,'C',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);
$pdf->SetX(10);
$pdf->Cell(82,4,utf8_decode(pg_fetch_result($rsate,0,'paciente')),'LTBR',0,'L',true);
//$pdf->Cell(28,4,'','LTBR',0,'L',true);

	$sq_tp="select c.nro_historia,substring(c.id_tipo_pac,1,1) as idpac_gen,pg.val_abr as pac_gen,substr(pg.descripcion,1,1)as tpaci_gen,
	substring(c.id_tipo_pac,3,1) as idpac_consul,pc.val_abr as pac_consul,substr(pc.descripcion,1,1)as tpaci_consul
	from cab_cie10 c 
	left join tablatipo pg on substring(c.id_tipo_pac,1,1)=pg.id_tipo and pg.id_tabla='84' 
	left join tablatipo pc on substring(c.id_tipo_pac,3,1)=pc.id_tipo and pc.id_tabla='84' 
	where c.nro_historia='".pg_fetch_result($rsate,0,'nro_historia')."'";
	$rs_tp=pg_query($cn,$sq_tp);
	if (pg_num_rows($rs_tp)>0){
		$tipopaciente=pg_fetch_result($rs_tp,0,'pac_gen')."/".pg_fetch_result($rs_tp,0,'pac_consul');
		$pdf->Cell(28,4,$tipopaciente,'LTBR',0,'L',true);
	} else {
		$pdf->Cell(28,4,'','LTBR',0,'L',true);
	}
	
	
/*	$sq_ncr="select extract(year from t.fecha_emision) as anhio,extract(year from now()) as aactual,count(t.nro_historia)as cantidad from tickets t 
	inner join cab_cie10 c on t.nro_historia=c.nro_historia 
	where t.id_paciente='".pg_fetch_result($rsate,0,'id_paciente')."' and t.id_consultorio='".pg_fetch_result($rsate,0,'id_consultorio')."'
	group by extract(year from t.fecha_emision)
	order by cast(extract(year from t.fecha_emision) as int) desc ";
	//echo $sq_ncr;
	$rs_ncr=pg_query($cn,$sq_ncr);
	$ncr_cnt=pg_num_rows($rs_ncr);
	switch ($ncr_cnt) {
		case '1':
			$pdf->Cell(28,4,'NUEVO','LTBR',0,'L',true);
			break;
		case ($ncr_cnt>1):
			$anhio_con=pg_fetch_result($rs_ncr,0,'anhio');
			$an_actual=pg_fetch_result($rs_ncr,0,'aactual');
			$cant=pg_fetch_result($rs_ncr,0,'cantidad');
			if (($anhio_con==$an_actual) && ($cant)){
				$pdf->Cell(28,4,'','LTBR',0,'L',true);
			}
			break;
	}*/
$pdf->Cell(20,4,substr(pg_fetch_result($rsate,0,'dni'),1,8),'LTBR',0,'L',true);
$pdf->Cell(10,4,pg_fetch_result($rsate,0,'sexo'),'LTBR',0,'L',true);
$pdf->Cell(24,4,pg_fetch_result($rsate,0,'edad'),'LTBR',0,'L',true);
$pdf->Cell(30,4,pg_fetch_result($rsate,0,'fecha_atencion'),'LTBR',1,'L',true);

if (pg_fetch_result($rsate,0,'ape_paterno_f')!=''){
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,6,'    FAMILIAR',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->SetFillColor(164,164,164);
	$pdf->SetTextColor(255,255,255);
	$pdf->Cell(100,4,'Nombres y Apellidos','LTBR',0,'C',true);
	$pdf->Cell(60,4,'Parentesco','LTBR',0,'C',true);
	$pdf->Cell(34,4,'DNI','LTBR',1,'C',true);
	$pdf->SetFillColor(255,255,255);
	$pdf->SetTextColor(0,0,0);
	$pdf->SetX(10);
	$pdf->Cell(100,4,utf8_decode(pg_fetch_result($rsate,0,'nombre_f').' '.pg_fetch_result($rsate,0,'ape_paterno_f').' '.pg_fetch_result($rsate,0,'ape_materno_f')),'LTBR',0,'L',true);
	$pdf->Cell(60,4,utf8_decode(pg_fetch_result($rsate,0,'parentesco_f')),'LTBR',0,'L',true);
	$pdf->Cell(34,4,pg_fetch_result($rsate,0,'dni_f'),'LTBR',1,'L',true);
}



$pdf->SetFont('Arial','BI',8);
$pdf->Cell(40,3,'',0,1,'');
$pdf->Cell(4,4,'2. ',0,0,'');
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(40,4,'ENFERMEDAD ACTUAL',0,1,'');
$pdf->SetFont('Arial','',8);
$pdf->SetX(10);


$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(64,4,'TIEMPO DE ENF','LTBR',0,'C',true);
$pdf->Cell(64,4,'INICIO','LTBR',0,'C',true);
$pdf->Cell(66,4,'CURSO','LTBR',1,'C',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);
$pdf->SetX(10);
$pdf->Cell(64,4,utf8_decode(pg_fetch_result($rsate,0,'inicio_enf')),'LTBR',0,'L',true);
$pdf->Cell(64,4,utf8_decode(pg_fetch_result($rsate,0,'tiempo_enf')),'LTBR',0,'L',true);
$pdf->Cell(66,4,utf8_decode(pg_fetch_result($rsate,0,'curso_enf')),'LTBR',1,'L',true);

$pdf->SetX(10);
$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(194,4,'MOTIVO','LTBR',1,'L',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);
$pdf->SetX(10);
$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'motivo')),'LBTR','J','');

$pdf->SetX(10);
$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(194,4,'RELATO','LTBR',1,'L',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);
$pdf->SetX(10);
$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'relato_enf')),'LBTR','J','');


$pdf->SetFont('Arial','BI',8);
$pdf->Cell(40,3,'',0,1,'');
$pdf->Cell(4,4,'3. ',0,0,'');
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(40,4,'ANTECEDENTES',0,1,'');
$pdf->SetFont('Arial','',8);
$sq="select ap.*,c.descripcion as diagnostico from det_ant_per ap left join cie10 c on c.cie10=ap.cie10 where nro_historia='".$_GET['hc']."'";
$rsap=pg_query($cn,$sq);
$ni=pg_num_rows($rsap);
$pdf->SetX(10);
$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(194,4,'Personales','LTBR',1,'L',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);
if ($ni>0){
for ($i=0;$i<$ni;$i++){
	
	if (pg_fetch_result($rsap,$i,'diagnostico')!=''){
		$pdf->SetX(10);	
		$pdf->Cell(20,4,'CIE','L',0,'R',true);
		$pdf->Cell(174,4,': '.pg_fetch_result($rsap,$i,'cie10').'-'.pg_fetch_result($rsap,$i,'diagnostico') ,'R',1,'L',true);
	}
	if (pg_fetch_result($rsap,$i,'id_mes')!=''){
		$pdf->SetX(10);
		$pdf->Cell(20,4,utf8_decode('Mes y Año'),'L',0,'R',true);
		$pdf->Cell(174,4,': '.get_name_month(pg_fetch_result($rsap,$i,'id_mes')).' '.pg_fetch_result($rsap,$i,'ano'),'R',1,'L',true);
	}
	if (pg_fetch_result($rsap,$i,'descripcion')!=''){
		$pdf->SetX(10);
		$pdf->Cell(20,5,utf8_decode('Descripcion'),'LB',0,'R',true);
		$pdf->Cell(174,5,': '.utf8_decode(pg_fetch_result($rsap,$i,'descripcion')),'RB',1,'L',true);
	}
}
}else{
	$pdf->SetX(10);
	$pdf->Cell(194,4,'SIN ANTECEDENTES','LTBR',1,'L',true);
}
/*****************************/



$a_fam=array();
$a_sfam=array();

$sq="select * from det_ant_fam where nro_historia='".$_GET['hc']."' order by cast(id_row as int)";
$rs=pg_query($cn,$sq);
$nr=pg_num_rows($rs);
$j=0;
for ($i=0;$i<$nr;$i++){
	$j++;
	$a_fam[$j][1]=pg_fetch_result($rs,$i,'id_parentesco');
	$a_fam[$j][2]=pg_fetch_result($rs,$i,'apellidos');
	$a_fam[$j][3]=pg_fetch_result($rs,$i,'nombres');
	$a_fam[$j][4]=pg_fetch_result($rs,$i,'vive');
	$a_fam[$j][5]=pg_fetch_result($rs,$i,'id_row');
	$a_fam[$j][6]=pg_fetch_result($rs,$i,'descripcion');
}
//sub cies de antec familiares
$sq="select s.id_row,s.cie10,c.descripcion from sub_ant_fam s left join cie10 c on s.cie10=c.cie10 where s.nro_historia='".$_GET['hc']."' order by cast(id_row as int)";
$rs=pg_query($cn,$sq);
$nr=pg_num_rows($rs);
$j=0;
for ($i=0;$i<$nr;$i++){
	$j++;
	$a_sfam[$j][1]=pg_fetch_result($rs,$i,'id_row');
	$a_sfam[$j][2]=pg_fetch_result($rs,$i,'cie10');
	$a_sfam[$j][3]=pg_fetch_result($rs,$i,'cie10').' | '.pg_fetch_result($rs,$i,'descripcion');
}
/*****************************/
$ma=$a_fam;
$ni=count($ma);
$sma=$a_sfam;
$nsi=count($sma);
$pdf->SetX(10);
$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(194,4,'Familiares','LTBR',1,'L',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);

if ($ni>0){
	for ($i=1;$i<=$ni;$i++){
		
		if ($ma[$i][1]!='' || $ma[$i][3]!=''){
			$pdf->SetX(10);
			$pdf->Cell(30,4,'Parentesco y Nombres','LT',0,'R',true);
			$sq="select descripcion from tablatipo where id_tabla='32' and id_tipo='".$ma[$i][1]."'";
			$rs=pg_query($cn,$sq);	
			$parent='';
			$_reg=pg_num_rows($rs);
			if ($_reg>0){
				$parent=pg_fetch_result($rs,0,'descripcion');
			}
			$pdf->Cell(164,4,': '.$parent.' - '.$ma[$i][3].' '. $ma[$i][2],'RT',1,'L',true);
		}
		
		
		
		if ($nsi>0){
			$pdf->SetX(10);
			$pdf->Cell(194,4,'Diagnosticos:','LTR',1,'L',true);
			for ($j=1;$j<=$nsi;$j++){ 
				if ($sma[$j][1]==$ma[$i][5]){
					$pdf->SetX(10);
					$pdf->Cell(194,4,str_replace('|','-',$sma[$j][3]),'LRB',1,'L',true);
				}
			}
		}
		
		$pdf->SetX(10);
		/*$pdf->SetFont('Arial','B',8);
		$pdf->Cell(194,4,'Descripcion','LTBR',1,'L',true);
		$pdf->SetFont('Arial','',8);
		$pdf->SetX(10);
		$pdf->Cell(194,4,$ma[$i][6],'LRB',1,'L',true);*/
		$pdf->Cell(20,5,'Descripcion','LB',0,'R',true);
		$pdf->Cell(174,5,': '.utf8_decode($ma[$i][6]),'RB',1,'L',true);
		
	}
}else{
	$pdf->SetX(10);
	$pdf->Cell(194,4,'SIN ANTECEDENTES','LTBR',1,'L',true);
}

$pdf->SetFont('Arial','BI',8);
$pdf->Cell(40,3,'',0,1,'');
$pdf->Cell(4,4,'4. ',0,0,'');
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(40,4,'EXAMEN CLINICO',0,1,'');
$pdf->SetX(10);
$pdf->Cell(40,4,'FUNCIONES VITALES',0,1,'');
$pdf->SetFont('Arial','',8);
$pdf->SetX(10);

$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(32,4,'Peso','LTBR',0,'C',true);
$pdf->Cell(32,4,'FC','LTBR',0,'C',true);
$pdf->Cell(32,4,'FR','LTBR',0,'C',true);
$pdf->Cell(32,4,'Pres/Art','LTBR',0,'C',true);
$pdf->Cell(22,4,'Talla','LTBR',0,'C',true);
$pdf->Cell(20,4,'IMC','LTBR',0,'C',true);
$pdf->Cell(24,4,'T('.utf8_decode('°').'C)','LTBR',1,'C',true);

$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);
$pdf->SetX(10);
$pdf->Cell(32,4,pg_fetch_result($rsate,0,'peso'),'LTBR',0,'L',true);
$pdf->Cell(32,4,pg_fetch_result($rsate,0,'frecuencia_car'),'LTBR',0,'L',true);
$pdf->Cell(32,4,pg_fetch_result($rsate,0,'frecuencia_res'),'LTBR',0,'L',true);
$pdf->Cell(32,4,pg_fetch_result($rsate,0,'presion_art'),'LTBR',0,'L',true);
$pdf->Cell(22,4,pg_fetch_result($rsate,0,'talla'),'LTBR',0,'L',true);
$pdf->Cell(20,4,pg_fetch_result($rsate,0,'imc'),'LTBR',0,'L',true);
$pdf->Cell(24,4,pg_fetch_result($rsate,0,'temperatura'),'LTBR',1,'L',true);
$pdf->SetX(10);


$pdf->SetFont('Arial','B',8);
$pdf->Cell(40,4,'EXAMEN GENERAL',0,1,'');
$pdf->SetFont('Arial','',8);
$pdf->SetX(10);
$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'examen_c_g')),'LBTR','J','');

/************************/
if (pg_fetch_result($rsate,0,'examen_c_e')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'UBICACION ESPACIO TEMPORAL',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'examen_c_e')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'nutricional')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'ESTADO NUTRICIONAL',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'nutricional')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'hidratacion')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'ESTADO DE HIDRATACION',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'hidratacion')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'piel')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'PIEL, FANERAS Y TEJIDO',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'piel')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'cabeza')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'CABEZA Y CUELLO',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'cabeza')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'torax')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'TORAX',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'torax')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'mamas')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'MAMAS',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'mamas')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'respiratorio')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'APARATO RESPIRATORIO',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'respiratorio')),'LBTR','J','');
}

if (pg_fetch_result($rsate,0,'cardiovascular')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'APARATO CARDIOVASCULAR',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'cardiovascular')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'pelvis')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'ABDOMEN PELVIS',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'pelvis')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'obstetrico')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'EXAMEN OBSTETRICO',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'obstetrico')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'genito')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'APARATO GENITOURINARIO',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'genito')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'nervioso')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'SISTEMA NERVIOSO',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'nervioso')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'osteo')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'OSTEOMIOARTICULAR',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'osteo')),'LBTR','J','');
}


/************************/

$pdf->SetFont('Arial','BI',8);
$pdf->Cell(40,3,'',0,1,'');
$pdf->Cell(4,4,'5. ',0,0,'');
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(40,4,'IMPRESION DIAGNOSTICA',0,1,'');
$pdf->SetFont('Arial','',8);
$pdf->SetX(10);

$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(24,4,'CIE10','LTBR',0,'L',true);
$pdf->Cell(10,4,'Tipo','LTBR',0,'L',true);
$pdf->Cell(160,4,'Descripcion del Diagnostico','LTBR',1,'L',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);

$sq="select d.cie10,c.descripcion,d.tipo from det_cie10 d inner join cie10 c on d.cie10=c.cie10 where d.nro_historia='".$_GET['hc']."'";
$rscie=pg_query($cn,$sq);
$ni=pg_num_rows($rscie);
if ($ni>0){
	for ($i=0;$i<$ni;$i++){
		$pdf->SetX(10);	
		$pdf->Cell(24,4,pg_fetch_result($rscie,$i,'cie10'),'LTBR',0,'L',true);
		$pdf->Cell(10,4,pg_fetch_result($rscie,$i,'tipo'),'LTBR',0,'L',true);
		$pdf->Cell(160,4,pg_fetch_result($rscie,$i,'descripcion'),'LTBR',1,'L',true);
	}
} else {
	$pdf->SetX(10);
	$pdf->Cell(24,4,'','LTBR',0,'L',true);
	$pdf->Cell(10,4,'','LTBR',0,'L',true);
	$pdf->Cell(160,4,'','LTBR',1,'L',true);
}

$pdf->SetFont('Arial','BI',8);
$pdf->Cell(40,3,'',0,1,'');
$pdf->Cell(4,4,'6. ',0,0,'');
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(80,4,'PROCEDIMIENTOS - EXAMENES AUX. - INTERVENCIONES',0,1,'');
$pdf->SetFont('Arial','',8);
$pdf->SetX(10);
$sq="select c.descripcion as especialidad,p.descripcion as producto,d.cantidad from det_aux d inner join consultorios c on substring(d.id_producto,1,6)=c.id_consultorio
	 inner join productos p on d.id_producto=p.id_producto where d.nro_historia='".$_GET['hc']."' order by c.descripcion,p.descripcion ";
$rsaux=pg_query($cn,$sq);
$ni=pg_num_rows($rsaux);
if ($ni>0){
	for ($i=0;$i<$ni;$i++){
		$pdf->SetX(10);	
		$pdf->Cell(186,4,pg_fetch_result($rsaux,$i,'especialidad').' - '.pg_fetch_result($rsaux,$i,'producto'),'LTBR',0,'L',true);
		$pdf->Cell(8,4,pg_fetch_result($rsaux,$i,'cantidad'),'LTBR',1,'R',true);
	}
} else {
	//$pdf->SetX(10);
	//$pdf->MultiCell(194,5,'','LBTR','J','');
}

//$pdf->MultiCell(194,20,'','LBTR','J','');

//$pdf->AddPage();

$pdf->SetFont('Arial','BI',8);
$pdf->Cell(40,3,'',0,1,'');
$pdf->Cell(4,4,'7. ',0,0,'');
$pdf->SetFont('Arial','UBI',7);
$pdf->Cell(40,4,'TRATAMIENTO',0,1,'');
$pdf->SetX(10);
$pdf->SetFont('Arial','',6);
$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(34,4,'Medicamento','LTBR',0,'C',true);
$pdf->Cell(20,4,'Concentracion','LTBR',0,'C',true);
$pdf->Cell(10,4,'Cant','LTBR',0,'C',true);
$pdf->Cell(20,4,'Forma Farmac.','LTBR',0,'C',true);
$pdf->Cell(20,4,'Dosis','LTBR',0,'C',true);
$pdf->Cell(20,4,'Interv. Dosis','LTBR',0,'C',true);
$pdf->Cell(20,4,'Via Adm','LTBR',0,'C',true);
$pdf->Cell(20,4,'Duracion','LTBR',0,'C',true);
$pdf->Cell(30,4,'Ind. Adic.','LTBR',1,'C',true);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);


$cad="select d.cantidad_un,d.id_medicamento,m.descripcion as medicamento,m.presentacion,m.concentracion,d.cantidad,d.id_dosis,d.id_via,d.frecuencia,d.duracion,ds.descripcion as dosis,vi.descripcion as via,
	  d.id_intervalo,d.adicionales,i.descripcion as intervalo from det_receta d inner join medicamentos m on d.id_medicamento=m.id_medicamento left join tablatipo ds on d.id_dosis=ds.id_tipo and ds.id_tabla='37' left join tablatipo i on d.id_intervalo=i.id_tipo and i.id_tabla='66' 
	  left join tablatipo vi on d.id_via=vi.id_tipo and vi.id_tabla='38' where d.nro_historia='".$_GET['hc']."'";
$rsrec=pg_query($cn,$cad);
$ni=pg_num_rows($rsrec);
if ($ni>0){
	for ($i=0;$i<$ni;$i++){
		$pdf->SetX(10);	
		$pdf->SetFont('Arial','',6);
		$pdf->Cell(34,4,utf8_decode(pg_fetch_result($rsrec,$i,'medicamento')),'LTBR',0,'L',true);
		$pdf->Cell(20,4,strtolower(pg_fetch_result($rsrec,$i,'concentracion')),'LTBR',0,'L',true);
		$pdf->Cell(10,4,strtolower(pg_fetch_result($rsrec,$i,'cantidad_un')),'LTBR',0,'R',true);
		$pdf->Cell(20,4,strtolower(pg_fetch_result($rsrec,$i,'presentacion')),'LTBR',0,'L',true);
		$pdf->Cell(20,4,strtolower(pg_fetch_result($rsrec,$i,'cantidad')),'LTBR',0,'R',true);
		$pdf->Cell(20,4,strtolower(pg_fetch_result($rsrec,$i,'intervalo')),'LTBR',0,'L',true);
		$pdf->Cell(20,4,strtolower(pg_fetch_result($rsrec,$i,'via')),'LTBR',0,'L',true);
		$pdf->Cell(20,4,strtolower(pg_fetch_result($rsrec,$i,'duracion')),'LTBR',0,'L',true);
		$pdf->Cell(30,4,strtolower(pg_fetch_result($rsrec,$i,'adicionales')),'LTBR',1,'L',true);
	}
} else {
	$pdf->SetX(10);
	$pdf->Cell(34,4,'','LTBR',0,'L',true);
	$pdf->Cell(20,4,'','LTBR',0,'L',true);
	$pdf->Cell(10,4,'','LTBR',0,'L',true);
	$pdf->Cell(20,4,'','LTBR',0,'L',true);
	$pdf->Cell(20,4,'','LTBR',0,'L',true);
	$pdf->Cell(20,4,'','LTBR',0,'L',true);
	$pdf->Cell(20,4,'','LTBR',0,'L',true);
	$pdf->Cell(20,4,'','LTBR',0,'L',true);
	$pdf->Cell(30,4,'','LTBR',1,'L',true);
}

/*$pdf->SetX(10);
$pdf->Cell(70,5,'','LTBR',0,'L',true);
$pdf->Cell(30,5,'','LTBR',0,'L',true);
$pdf->Cell(20,5,'','LTBR',0,'L',true);
$pdf->Cell(40,5,'','LTBR',0,'L',true);
$pdf->Cell(34,5,'','LTBR',1,'L',true);*/

$pdf->SetFont('Arial','BI',8);
$pdf->Cell(40,3,'',0,1,'');
$pdf->Cell(4,4,'8. ',0,0,'');
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(40,4,'OBSERVACIONES (REFERENCIA-PROXIMA CITA, OTROS)',0,1,'');
$pdf->SetFont('Arial','',8);
$pdf->SetX(10);
$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'tratamiento')),'LTBR','J','');

if (pg_fetch_result($rsate,0,'dieta')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'DIETA',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'dieta')),'LBTR','J','');
}
if (pg_fetch_result($rsate,0,'interconsulta')!=''){
	$pdf->SetX(10);
	$pdf->SetFont('Arial','B',8);
	$pdf->Cell(40,4,'INTERCONSULTA',0,1,'');
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'interconsulta')),'LBTR','J','');
}

if (pg_fetch_result($rsate,0,'proxima_cita')!=''){
	$pdf->SetFont('Arial','',8);
	$pdf->SetX(10);
	$pdf->MultiCell(194,4,'PROXIMA CITA: '.utf8_decode(pg_fetch_result($rsate,0,'proxima_cita')),'LBTR','J','');
}

//$pdf->SetX(10);
//$pdf->MultiCell(194,4,utf8_decode(pg_fetch_result($rsate,0,'tratamiento')),'LTBR','J','');

$pdf->SetX(10);
$pdf->SetFont('Arial','UBI',8);
$pdf->Cell(40,5,'Datos del Profesional',0,1,'');

$pdf->SetX(10);
$pdf->SetFont('Arial','',8);
$pdf->SetFillColor(164,164,164);
$pdf->SetTextColor(255,255,255);
$pdf->Cell(90,4,'Profesional de la Salud','LTBR',0,'C',true);
$pdf->Cell(40,4,'Colegio Profesional','LTBR',0,'C',true);
$pdf->Cell(40,4,'Consultorio.','LTBR',0,'C',true);
$pdf->Cell(24,4,'Turno','LTBR',1,'C',true);


$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(0,0,0);
$pdf->SetX(10);
$pdf->Cell(90,4,utf8_decode(pg_fetch_result($rsate,0,'medico')),'LTBR',0,'L',true);

//$idx=$_POST['hcmpmedico'];
/*$sql="select tncol from personal where id_personal='".$idx."'";
$cmp='';

$rs=pg_query($cn,$sql);
$nr=pg_num_rows($rs);
if ($nr>0){
	$cmp=substr(pg_fetch_result($rs,0,'tncol'),1,6);
}else{
	$cmp='';
}*/

$pdf->Cell(40,4,pg_fetch_result($rsate,0,'tncol'),'LTBR',0,'L',true);
$pdf->Cell(40,4,pg_fetch_result($rsate,0,'bus'),'LTBR',0,'L',true);
/*if (isset($_POST['txtturno'])){
	$tu=utf8_decode($_POST['txtturno']);
}else{
	$tu='';
}*/
$pdf->Cell(24,4,utf8_decode(pg_fetch_result($rsate,0,'turno')),'LTBR',1,'L',true);
$pdf->SetX(10);
$pdf->Cell(170,4,'Codigo Personal de Salud','LTBR',0,'R',true);
$pdf->Cell(24,4,'','LTBR',1,'L',true);
$pdf->Output();
?>
