<?php

/*
 * Verificacin de los parmetros obligatorios y opcionales.
 * ------------------------------------------------------------------------
 */
if (empty($_pagi_sql)) {
    // Si no se defini $_pagi_sql... grave error!
    // Este error se muestra s o s (ya que no es un error de mysql)
    die("<b>Error Paginator : </b>No se ha definido la variable \$_pagi_sql");
}

if (empty($_pagi_cuantos)) {
    // Si no se ha especificado la cantidad de registros por pgina
    // $_pagi_cuantos ser por defecto 20
    $_pagi_cuantos = 20;
}

if (!isset($_pagi_mostrar_errores)) {
    // Si no se ha elegido si se mostrar o no errores
    // $_pagi_errores ser por defecto true. (se muestran los errores)
    $_pagi_mostrar_errores = true;
}

if (!isset($_pagi_conteo_alternativo)) {
    // Si no se ha elegido el tipo de conteo
    // Se realiza el conteo dese mySQL con COUNT(*)
    $_pagi_conteo_alternativo = false;
}

if (!isset($_pagi_separador)) {
    // Si no se ha elegido un separador
    // Se toma el separador por defecto.
    $_pagi_separador = " | ";
}

if (isset($_pagi_nav_estilo)) {
    // Si se ha definido un estilo para los enlaces, se genera el atributo "class" para el enlace
    $_pagi_nav_estilo_mod = "class=\"$_pagi_nav_estilo\"";
} else {
    // Si no, se utiliza una cadena vaca.
    $_pagi_nav_estilo_mod = "";
}

if (!isset($_pagi_nav_anterior)) {
    // Si no se ha elegido una cadena para el enlace "siguiente"
    // Se toma la cadena por defecto.
    $_pagi_nav_anterior = "&laquo; Anterior";
}

if (!isset($_pagi_nav_siguiente)) {
    // Si no se ha elegido una cadena para el enlace "siguiente"
    // Se toma la cadena por defecto.
    $_pagi_nav_siguiente = "Siguiente &raquo;";
}

//------------------------------------------------------------------------


/*
 * Establecimiento de la pgina actual.
 * ------------------------------------------------------------------------
 */
if (empty($_GET['_pagi_pg'])) {
    // Si no se ha hecho click a ninguna pgina especfica
    // O sea si es la primera vez que se ejecuta el script
    // $_pagi_actual es la pagina actual-->ser por defecto la primera.
    $_pagi_actual = 1;
} else {
    // Si se "pidi" una pgina especfica:
    // La pgina actual ser la que se pidi.
    $_pagi_actual = $_GET['_pagi_pg'];
}

if (empty($_GET['_pagi_ini'])) {
    $_pagi_ini = 1;
}else{
    $_pagi_ini = $_GET['_pagi_ini'];
}

$_pagi_navigacion_tope = $_pagi_ini + 4;

//echo $_GET['pagi_funcion'];
if (empty($_GET['pagi_funcion'])) {
    $_pagi_funcion = "view_buscar";
} else {
    $_pagi_funcion = $_GET['pagi_funcion'];
}

if (isset($_GET['tipo'])) {
    $tipo = $_GET['tipo'];
} else {
    $tipo = "";
}

//------------------------------------------------------------------------


/*
 * Establecimiento del nmero de pginas y del total de registros.
 * ------------------------------------------------------------------------
 */
// Contamos el total de registros en la BD (para saber cuntas pginas sern)
// La forma de hacer ese conteo depender de la variable $_pagi_conteo_alternativo
if ($_pagi_conteo_alternativo == false) {
    $_pagi_result = pg_query($_pagi_sql);
    $_pagi_totalReg = pg_num_rows($_pagi_result);
    //$_pagi_sqlConta = eregi_replace("select (.*) from", "SELECT COUNT(*) FROM", $_pagi_sql);
    //$_pagi_result2 = pg_query($_pagi_sqlConta);
    // Si ocurri error y mostrar errores est activado
    //if($_pagi_result2 == false && $_pagi_mostrar_errores == true){
    //	die (" Error en la consulta de conteo de registros: $_pagi_sqlConta. Postgres dijo: <b>". pg_last_error()."</b>");
    //}
    //$_pagi_totalReg = pg_result($_pagi_result2,0,0);//total de registros
} else {
    $_pagi_result = pg_query($_pagi_sql);
    // Si ocurri error y mostrar errores est activado
    if ($_pagi_result == false && $_pagi_mostrar_errores == true) {
        die(" Error en la consulta de conteo alternativo de registros: $_pagi_sql. Postgres dijo: <b>" . pg_last_error() . "</b>");
    }
    $_pagi_totalReg = mysql_num_rows($_pagi_result);
}
// Calculamos el nmero de pginas (saldr un decimal)
// con ceil() redondeamos y $_pagi_totalPags ser el nmero total (entero) de pginas que tendremos
$_pagi_totalPags = ceil($_pagi_totalReg / $_pagi_cuantos);

//------------------------------------------------------------------------


/*
 * Propagacin de variables por el URL.
 * ------------------------------------------------------------------------
 */
// La idea es pasar tambin en los enlaces las variables hayan llegado por url.
$_pagi_enlace = $_SERVER['PHP_SELF'];


$_pagi_query_string = "?";

if (!isset($_pagi_propagar)) {
    //Si no se defini qu variables propagar, se propagar todo el $_GET (por compatibilidad con versiones anteriores)
    $_pagi_propagar = array_keys($_GET);
} elseif (!is_array($_pagi_propagar)) {
    // si $_pagi_propagar no es un array... grave error!
    die("<b>Error Paginator : </b>La variable \$_pagi_propagar debe ser un array");
}
// Este foreach est tomado de la Clase Paginado de webstudio
// (http://www.forosdelweb.com/showthread.php?t=65528)
foreach ($_pagi_propagar as $var) {
    if (isset($GLOBALS[$var])) {
        // Si la variable es global al script
        $_pagi_query_string.= $var . "=" . $GLOBALS[$var] . "&";
    } elseif (isset($_REQUEST[$var])) {
        // Si no es global (o register globals est en OFF)
        $_pagi_query_string.= $var . "=" . $_REQUEST[$var] . "&";
    }
}

// Aadimos el query string a la url.
$_pagi_enlace .= $_pagi_query_string;
// echo "<p>_pagi_enlace = $_pagi_enlace</p>";
//------------------------------------------------------------------------
//Esto lo hago para saber si estoy en una pgina con el htaccess. 
//Porque entonces la propagacion de las variables para los enlaces de paginacion seria distinta
    /*
     * Generacin de los enlaces de paginacin.
     * ------------------------------------------------------------------------
     */
    // La variable $_pagi_navegacion contendr los enlaces a las pginas.
    $_pagi_navegacion_temporal = array();

    //$_pagi_ini es cuantas veces se nos va a mostrar os 3 puntos empieza de 1 se aumenta o disminuye segun sea el caso
    //$_pagi_navigacion_tope es la suma del inicio actual mas el nro de paginas que deseo mostrar
    //$_pagi_totalPags es la division de total de registro entre el total de registros($total_registros) por pagina($registros)
    if ($_pagi_ini > 1) {
        //Muestra la primera pagina no importa a la izqueirda
        $_pagi_navegacion_temporal[] = "<a " . $_pagi_nav_estilo_mod . "  onClick=\"$_pagi_funcion('" . $tipo . "','1','1')\" style='cursor:pointer;' title='Ir a la p&aacute;gina 1'>1</a>";
        //echo "&nbsp;<a href='main_productos.php?pagina=1" . "&inicio=1&id_tipo=" . $id_tipo . "&descripcion=" . $descripcion . "' title='Ir a la p&aacute;gina 1'>1</a>";
        //Aqui mestra los 3 puntitos en el lado izquierdo.
        if ($_pagi_ini - 5 <= 0) {
            //este lleva a los primeros 5 enlaces de la primera pagina
            $_pagi_navegacion_temporal[] = "<a " . $_pagi_nav_estilo_mod . "  onClick=\"$_pagi_funcion('" . $tipo . "','1','1')\" style='cursor:pointer;' title='Ir a la p&aacute;gina 1'>...</a>";
            //echo "&nbsp;<a href='main_productos.php?inicio=1&pagina=1&id_consultorio=" . $id_tipo . "&descripcion=" . $descripcion . "' title='Conjunto anterior de p&aacute;ginas'>...</a>";
        } else {
            //este lleva a las anteriores enlaces de la pagina anterior
            $_pagi_navegacion_temporal[] = "<a " . $_pagi_nav_estilo_mod . "  onClick=\"$_pagi_funcion('" . $tipo . "','" . ($_pagi_ini - 5) . "','" . ($_pagi_ini - 5) . "')\" style='cursor:pointer;' title='onjunto anterior de p&aacute;ginas'>...</a>";
            //echo "&nbsp;<a href='main_productos.php?inicio=" . ($_pagi_ini - 5) . "&pagina=" . ($_pagi_ini - 5) . "&id_tipo=" . $id_tipo . "&descripcion=" . $descripcion . "' title='Conjunto anterior de p&aacute;ginas'>...</a>";
        }
    }
    for ($i = $_pagi_ini; $i <= $_pagi_navigacion_tope; $i++) {
        if ($i <= $_pagi_totalPags)
            if ($_pagi_actual == $i)
            //if ($pagina==$i) Pagina actual
                $_pagi_navegacion_temporal[] = "&nbsp;<b>$i</b>";
            else
            //Paginas anteriores o siguientes de la pagina actual
                $_pagi_navegacion_temporal[] = "<a " . $_pagi_nav_estilo_mod . "  onClick=\"$_pagi_funcion('" . $tipo . "','" . $_pagi_ini . "','" . $i . "')\" style='cursor:pointer;' title='Ir a la p&aacute;gina $i'>$i</a>";
        //echo "&nbsp;<a title='Ir a la p&aacute;gina $i' href='main_productos.php?pagina=$i" . "&inicio=" . $_pagi_ini . "&id_tipo=" . $id_tipo . "&descripcion=" . $descripcion . "'>$i</a>";
    }
    //$i es el valor que quede despues de aunmentarse el valor en el for que seria $_pagi_ini + $tope
    if ($i <= $_pagi_totalPags) {
        //Aqui mestra los 3 puntitos si es no $i es menor al total de paginas.
        $_pagi_navegacion_temporal[] = "<a " . $_pagi_nav_estilo_mod . "  onClick=\"$_pagi_funcion('" . $tipo . "','" . ($_pagi_ini + 5) . "','" . ($_pagi_ini + 5) . "')\" style='cursor:pointer;' title='Siguiente conjunto de p&aacute;ginas'>...</a>";
        //echo "&nbsp;<a href='main_productos.php?inicio=" . ($_pagi_ini + 5) . "&pagina=" . ($_pagi_ini + 5) . "&id_tipo=" . $id_tipo . "&descripcion=" . $descripcion . "' title='Siguiente conjunto de p&aacute;ginas'>...</a>";
        //Es la ultima pagina que vendria ser el total de paginas.
        $_pagi_navegacion_temporal[] = "<a " . $_pagi_nav_estilo_mod . "  onClick=\"$_pagi_funcion('" . $tipo . "','" . ($_pagi_totalPags - 4) . "','" . $_pagi_totalPags . "')\" style='cursor:pointer;' title='Ir a la p&aacute;gina $_pagi_totalPags'>$_pagi_totalPags</a>";
        //echo "&nbsp;<a href='main_productos.php?pagina=" . $_pagi_totalPags . "&inicio=" . ($_pagi_totalPags - 4) . "&id_tipo=" . $id_tipo . "&descripcion=" . $descripcion . "' title='Ir a la p&aacute;gina $_pagi_totalPags'>$_pagi_totalPags</a>";
    }

$_pagi_navegacion = implode($_pagi_separador, $_pagi_navegacion_temporal);
/*
 * ------------------------------------------------------------------------
 */

/*
 * Obtencin de los registros que se mostrarn en la pgina actual.
 * ------------------------------------------------------------------------
 */
// Calculamos desde qu registro se mostrar en esta pgina
// Recordemos que el conteo empieza desde CERO.
$_pagi_inicial = ($_pagi_actual - 1) * $_pagi_cuantos;

// Consulta SQL. Devuelve $cantidad registros empezando desde $_pagi_inicial
$_pagi_sqlLim = $_pagi_sql . " LIMIT $_pagi_cuantos offset $_pagi_inicial";
$_pagi_result = pg_query($_pagi_sqlLim);
// Si ocurri error y mostrar errores est activado
if ($_pagi_result == false && $_pagi_mostrar_errores == true) {
    die("Error en la consulta limitada: $_pagi_sqlLim. Postgres dijo: <b>" . pg_result_error() . "</b>");
}

//------------------------------------------------------------------------

/*
 * Generacin de la informacin sobre los registros mostrados.
 * ------------------------------------------------------------------------
 */
// Nmero del primer registro de la pgina actual
$_pagi_desde = $_pagi_inicial + 1;

// Nmero del ltimo registro de la pgina actual
$_pagi_hasta = $_pagi_inicial + $_pagi_cuantos;
if ($_pagi_hasta > $_pagi_totalReg) {
    // Si estamos en la ltima pgina
    // El ultimo registro de la pgina actual ser igual al nmero de registros.
    $_pagi_hasta = $_pagi_totalReg;
}

$_pagi_info = " <span class=fuente8><b>Se muestran desde el $_pagi_desde hasta el $_pagi_hasta de un total de $_pagi_totalReg pginas</b></span>";
$_pagi_info_scripts = " <span class=fuente8><b>Encontrados $_pagi_totalReg scripts. Se muestran desde el $_pagi_desde hasta el $_pagi_hasta.</b></span>";
$_pagi_info_articulos = " <span class=fuente8><b>Encontrados $_pagi_totalReg artculos. Se muestran desde el $_pagi_desde hasta el $_pagi_hasta.</b></span>";
$_pagi_muestran = " <span class=fuente8><b>Se muestran desde el $_pagi_desde hasta el $_pagi_hasta</b></span>";
//------------------------------------------------------------------------
?>