<?php
include_once (realpath( dirname( __FILE__ )).'/../clases/clinica.class.php');
class Pacientes {
  private $db;
  private $sql;

  public function __construct() {
    $this->db = new ConectaDb();
    $this->rs = array();
  }

  public function listPacientesMain($sWhere,$sOrder,$sLimit){
    $this->db->getConnection();
    $this->sql = "
    select p.id_paciente,p.nombre,p.ape_paterno,p.ape_materno,p.asegurado,p.odoc,p.e_mail,substring(p.id_usuario_salud,2,10) as \"substring(p.id_usuario_salud,2,8)\",substring(p.id_usuario_salud,1,1) as tip_doc_identidad,tt.val_abr,
    p.fecha_nac,p.edad,p.sexo,p.telefono,p.direccion,u.distrito,p.id_distrito,p.ruc,p.edad_dias,p.edad_meses,p.id_estado,
    p.grupo_s,p.propaganda, p.id_ubigeonac,p.est_civil,p.id_nacionalidad,p.id_ginstruccion,ln.distrito as lugar_nacimiento,
    p.id_religion,p.id_ocupacion,nro_historia_old
    from pacientes p left join ubigeo2005 u on p.id_distrito=u.ubigeo
    left join tablatipo tt on tt.id_tabla='9' and substring(p.id_usuario_salud,1,1)=tt.id_tipo
    left join ubigeo2005 ln on p.id_ubigeonac=ln.ubigeo
    where p.id_paciente<>'' ".$sWhere.$sOrder.$sLimit;
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }


  public function countlistPacientesMain($sWhere){
    $this->db->getConnection();
    $this->sql = "
    SELECT count(*) as cnt from
    pacientes p left join ubigeo2005 u on p.id_distrito=u.ubigeo
    left join tablatipo tt on tt.id_tabla='9' and substring(p.id_usuario_salud,1,1)=tt.id_tipo
    left join ubigeo2005 ln on p.id_ubigeonac=ln.ubigeo ".$sWhere;
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs[0]['cnt'];
  }


  public function listPacientes($sWhere,$sOrder,$sLimit){
    $this->db->getConnection();
    $this->sql = "
    select case  when p.sexo ='M' then 'Masculino' else 'Femenino' end as sexo,p.edad,p.edad_meses,p.edad_dias, p.id_paciente,p.nombre,p.ape_paterno,p.ape_materno,substring(p.id_usuario_salud,2,8) as \"substring(p.id_usuario_salud,2,8)\"
    from pacientes p left join ubigeo2005 u on p.id_distrito=u.ubigeo
    left join ubigeo2005 un on p.id_ubigeonac=un.ubigeo
    left join tablatipo tt on tt.id_tabla='9' and substring(p.id_usuario_salud,1,1)=tt.id_tipo
    where p.id_paciente<>''  and (p.id_estado<>'2' or p.id_estado is null) ".$sWhere.$sOrder.$sLimit;;
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }


  public function countlistPacientes($sWhere){
    $this->db->getConnection();
    $this->sql = "
    SELECT count(*) as cnt from
    pacientes p left join ubigeo2005 u on p.id_distrito=u.ubigeo
    left join ubigeo2005 un on p.id_ubigeonac=un.ubigeo
    left join tablatipo tt on tt.id_tabla='9' and substring(p.id_usuario_salud,1,1)=tt.id_tipo
    where p.id_paciente<>''  and (p.id_estado<>'2' or p.id_estado is null) ".$sWhere;
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs[0]['cnt'];
  }

  public function SearchPacienteCoti($nro_doc){
    $this->db->getConnection();
    $this->sql = "
    select p.id_paciente,p.nombre,p.ape_paterno,p.ape_materno,substring(p.id_usuario_salud,2,8) as dni,
					  substring(p.id_usuario_salud,1,1) as tip_doc_identidad,
					  p.asegurado,p.odoc,p.e_mail,p.ruc,tt.val_abr,p.edad_meses,p.edad_dias,
					  p.fecha_nac,p.edad,p.sexo,p.telefono,p.direccion,u.distrito,p.id_distrito,p.id_parentesco,p.id_titular,
            substring(p.id_distrito,1,4) as id_pro,	substring(p.id_distrito,1,2) as id_dep,
					  p.id_ubigeonac,p.est_civil,p.id_nacionalidad,p.id_ginstruccion,p.id_religion,p.id_ocupacion,un.distrito as lnacimiento,
            u.departamento,u.provincia,u.distrito
					  from pacientes p left join ubigeo2005 u on p.id_distrito=u.ubigeo
					  left join ubigeo2005 un on p.id_ubigeonac=un.ubigeo
					  left join tablatipo tt on tt.id_tabla='9' and substring(p.id_usuario_salud,1,1)=tt.id_tipo
					  where p.id_paciente<>''  and (p.id_estado<>'2' or p.id_estado is null) and substring(p.id_usuario_salud,2,8) = '".$nro_doc."'   ";
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }

  public function SearchPacienteOld($name,$apep,$apem){
    $this->db->getConnection();
    $this->sql = "
    select p.id_paciente from pacientes p   where p.id_paciente<>''  and p.nombre ='".strtoupper($name)."' and p.ape_paterno ='".strtoupper($apep)."' and p.ape_materno ='".strtoupper($apem)."'  ";
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }


  public function SearchPaciente($nro_doc){
    $this->db->getConnection();
    $this->sql = "
    select p.id_paciente,p.nombre,p.ape_paterno,p.ape_materno,substring(p.id_usuario_salud,2,8) as dni,
					  substring(p.id_usuario_salud,1,1) as tip_doc_identidad,
					  p.asegurado,p.odoc,p.e_mail,p.ruc,tt.val_abr,p.edad_meses,p.edad_dias,
					  p.fecha_nac,p.edad,p.sexo,p.telefono,p.direccion,u.distrito,p.id_distrito,p.id_parentesco,p.id_titular,
            substring(p.id_distrito,1,4) as id_pro,	substring(p.id_distrito,1,2) as id_dep,
					  p.id_ubigeonac,p.est_civil,p.id_nacionalidad,p.id_ginstruccion,p.id_religion,p.id_ocupacion,un.distrito as lnacimiento
					  from pacientes p left join ubigeo2005 u on p.id_distrito=u.ubigeo
					  left join ubigeo2005 un on p.id_ubigeonac=un.ubigeo
					  left join tablatipo tt on tt.id_tabla='9' and substring(p.id_usuario_salud,1,1)=tt.id_tipo
					  where p.id_paciente<>''  and (p.id_estado<>'2' or p.id_estado is null) and substring(p.id_usuario_salud,2,8) like '%".$nro_doc."%'   ";
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }

  public function PacientesGet($nro_doc){
    $this->db->getConnection();
    $this->sql = "
    select p.id_paciente,p.nombre,p.ape_paterno,p.ape_materno,substring(p.id_usuario_salud,2,8) as dni,
(p.edad||' a. '||p.edad_meses||' m. '||p.edad_dias||' d.') as edad,
CASE WHEN p.sexo ='M' THEN 'Masculino' WHEN p.sexo ='F' THEN 'Femenino' END as sexo
    from pacientes p left join ubigeo2005 u on p.id_distrito=u.ubigeo
    left join ubigeo2005 un on p.id_ubigeonac=un.ubigeo
    left join tablatipo tt on tt.id_tabla='9' and substring(p.id_usuario_salud,1,1)=tt.id_tipo
    where p.id_paciente<>''  and (p.id_estado<>'2' or p.id_estado is null) and substring(p.id_usuario_salud,2,8)= '".$nro_doc."'   ";
    //echo $this->sql;exit();
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }
  public function itemsQry($id_tbl){
    $this->db->getConnection();
    $this->sql = "SELECT "
    ."id_tipo,id_estado,protegido,"
    ."descripcion FROM lab_tablas WHERE id_tabla='$id_tbl' and id_tipo<>'0' ORDER BY descripcion";
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }

  public function tablasList() {
    $this->db->getConnection();
    $this->sql = 	"SELECT id_tabla,id_tipo,descripcion
    FROM
    lab_tablas WHERE id_tabla='0' ORDER By descripcion";
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }



  public function tablasQry($offset,$limit,$sidx,$sord,$awhere,$id_tabla) {
    $this->db->getConnection();
    $this->sql = 	"SELECT id_tabla,id_tipo,descripcion,id_estado,abreviado,
    to_char(fecha_ing,'dd/mm/yyyy HH:MI:SS AM') AS fecha_ing,
    to_char(fecha_mod,'dd/mm/yyyy HH:MI:SS AM') AS fecha_mod
    FROM
    lab_tablas ";
    $swhere=' WHERE ';
    $n=count($awhere);
    if ($n>0){
      foreach ($awhere as $row){
        $swhere.=$row['field']." LIKE '%".$row['data']."%' AND ";
      }
    }
    $swhere.=" id_tabla='$id_tabla' ";
    if ($id_tabla=='0'){
      $swhere.="AND id_tipo<>'0' ";
    }
    $this->sql.=$swhere."ORDER BY ";
    $this->sql.=$sidx." ";
    $this->sql.=$sord." "."LIMIT ".$limit." OFFSET ".$offset;

    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs;
  }

  public function tablasCnt($awhere,$id_tabla) {
    $this->db->getConnection();
    $this->sql = "SELECT count(*) as cnt from lab_tablas ";
    $swhere=' WHERE ';
    $n=count($awhere);
    if ($n>0){
      foreach ($awhere as $row){
        $swhere.=$row['field']." LIKE '%".$row['data']."%' AND ";
      }
    }
    $swhere.=" id_tabla='".$id_tabla."' ";
    if ($id_tabla=='0'){
      $swhere.="AND id_tipo<>'1' ";
    }

    $this->sql.=$swhere;
    $this->rs=$this->db->query($this->sql);
    $this->db->closeConnection();
    return $this->rs[0]['cnt'];
  }
  public function tablasCrud($a,$action){
    $result=NULL;
    $this->db->getConnection();
    $aparams=array($action,$a[0]['id_tabla'],$a[0]['id_tipo'],$a[0]['descripcion'],$a[0]['abreviado'],$a[0]['id_estado'],$a[0]['s_id_usuario']);
    $this->sql="select sp_crud_lab_tablas($1,$2,$3,$4,$5,$6,$7)";
    $this->rs=$this->db->query_params($this->sql,$aparams);
    $this->db->closeConnection();
    return $this->rs[0][0];
  }
}
