function alert_principal(tipo_alerta, mensaje) {
  $('#info_principal').removeClass('invisible');
  $('#info_principal').attr('style','');
  $('#info_principal_alert').attr('class','alert alert-'+ tipo_alerta);
  $('#mensaje_alert').html(mensaje);
  setTimeout(function() {
    $('#info_principal').fadeOut('fast');
  }, 7000);
}

var UITree = function () {
  var handleSample0 = function () {
    $('#prueba').jstree({
      "plugins": ["json_data", "themes", "ui", "crrm", "dnd", "search", "contextmenu"],
      "themes": {"theme": "apple"},
      "ui": {"select_limit": 1, "selected_parent_close": "deselect", "disable_selecting_children": "true", "initially_select": [0]},
      "crrm": {"input_width_limit": "50", "move": {"always_copy": "multitree"}},
      "dnd": {"open_timeout": "700"},
      "search": {},
      "contextmenu": {"select_node": "true"},
      "json_data" :
      {
        "ajax" :
        {
          "url" : "{{ url('components/tree/findall') }}",
          // the `data` function is executed in the instance's scope
          // the parameter is the node being loaded
          // (may be -1, 0, or undefined when loading the root nodes)
          "data" : function (node) {
            console.info("Nodes:",node);
            return {
              "operation" : "get_children",
              "id" : node.attr ? node.attr("id").replace("node_","") : 1
            };
          }
        }
      }
    })
  }

  var handleSample1 = function () {
    $('#tree_1').jstree({
      "core" : {
        "themes" : {
          "responsive": false
        }
      },
      "types" : {
        "default" : {
          "icon" : "fa fa-folder icon-warning icon-lg"
        },
        "file" : {
          "icon" : "fa fa-file icon-warning icon-lg"
        }
      },
      "plugins": ["types"]
    });

  }

  var handleSample2 = function () {
    $('#tree_2').jstree({
      'plugins': ["wholerow", "checkbox", "types"],
      'core': {
        "themes" : {
          "responsive": false
        },
        'data': [{
          "text": "Same but with checkboxes",
          "children": [{
            "text": "initially selected",
            "state": {
              "selected": true
            }
          }, {
            "text": "custom icon",
            "icon": "fa fa-warning icon-danger"
          }, {
            "text": "initially open",
            "icon" : "fa fa-folder icon-default",
            "state": {
              "opened": true
            },
            "children": ["Another node"]
          }, {
            "text": "custom icon",
            "icon": "fa fa-warning icon-warning"
          }, {
            "text": "disabled node",
            "icon": "fa fa-check icon-success",
            "state": {
              "disabled": true
            }
          }]
        },
        "And wholerow selection"
      ]
    },
    "types" : {
      "default" : {
        "icon" : "fa fa-folder icon-warning icon-lg"
      },
      "file" : {
        "icon" : "fa fa-file icon-warning icon-lg"
      }
    }
  });
}

var contextualMenuSample = function() {
  $("#tree_3").jstree({
    "core" : {
      "themes" : {
        "responsive": false
      },
      // so that create works
      "check_callback" : true,
      'data': [{
        "text": "Parent Node",
        "children": [{
          "text": "Initially selected",
          "state": {
            "selected": true
          }
        }, {
          "text": "Custom Icon",
          "icon": "fa fa-warning icon-danger"
        }, {
          "text": "Initially open",
          "icon" : "fa fa-folder icon-success",
          "state": {
            "opened": true
          },
          "children": [
            {"text": "Another node", "icon" : "fa fa-file icon-warning"}
          ]
        }, {
          "text": "Another Custom Icon",
          "icon": "fa fa-warning icon-warning"
        }, {
          "text": "Disabled Node",
          "icon": "fa fa-check icon-success",
          "state": {
            "disabled": true
          }
        }, {
          "text": "Sub Nodes",
          "icon": "fa fa-folder icon-danger",
          "children": [
            {"text": "Item 1", "icon" : "fa fa-file icon-warning"},
            {"text": "Item 2", "icon" : "fa fa-file icon-success"},
            {"text": "Item 3", "icon" : "fa fa-file icon-default"},
            {"text": "Item 4", "icon" : "fa fa-file icon-danger"},
            {"text": "Item 5", "icon" : "fa fa-file icon-info"}
          ]
        }]
      },
      "Another Node"
    ]
  },
  "types" : {
    "default" : {
      "icon" : "fa fa-folder icon-warning icon-lg"
    },
    "file" : {
      "icon" : "fa fa-file icon-warning icon-lg"
    }
  },
  "state" : { "key" : "demo2" },
  "plugins" : [ "contextmenu", "dnd", "state", "types" ]
});
}

var ajaxTreeSample = function() {
  $("#tree_4").jstree({
    "core" : {
      "themes" : {
        "responsive": false
      },
      // so that create works
      "check_callback" : true,
      'data' : {
        'url' : function (node) {
          return 'demo/jstree_ajax_data.php';
        },
        'data' : function (node) {
          return { 'parent' : node.id };
        }
      }
    },
    "types" : {
      "default" : {
        "icon" : "fa fa-folder icon-warning icon-lg"
      },
      "file" : {
        "icon" : "fa fa-file icon-warning icon-lg"
      }
    },
    "state" : { "key" : "demo3" },
    "plugins" : [ "dnd", "state", "types" ]
  });
}
return {
  //main function to initiate the module
  init: function () {
    handleSample0();
    handleSample1();
    handleSample2();
    contextualMenuSample();
    ajaxTreeSample();
  }
};
}();

function placeItemMenu(idmenu,idsub,namesub,coman,img1,img2,est){
  $('#txtoption').val('U');
  $('#cboidmenu').val(idmenu);
  $('#txtorden').val(idsub);
  $('#txtdescripcion').val(namesub);
  $('#txtcomando').val(coman);
  $('#txtimagen1').val(img1);
  $('#txtimagen2').val(img2);
  $('#cboestado').val(est);
  $("#saveMenu").text('Actualizar');
}

function loadorder(idmenu){
  var parametros = {"action":"loadorder","idmenu":idmenu};
  $.ajax({
    data:  parametros,
    url:   '../controller/ctrlMain.php',
    type:  'get',
    beforeSend: function () {
      //$("#div_img").html("<img src='../dist/img/ajax-loader.gif'>");
    },
    success:  function (response) {
      $('#txtorden').val(response)
      //$("#div_img").html(response);
    }
  });
}

function newMenu(){
  $('#txtoption').val('I');
  $('#cboidmenu').val('');
  $('#txtorden').val('');
  $('#txtdescripcion').val('');
  $('#txtcomando').val('');
  $('#txtimagen1').val('');
  $('#txtimagen2').val('');
  $('#cboestado').val('');
  $("#saveMenu").text('Grabar');

}


function saveMenu(){
  var opt=$('#txtoption').val();
  var cboidmenu= $('#cboidmenu').val();
  var cboidmenudes= $("#cboidmenu option:selected").text();
  var txtorden= $('#txtorden').val();
  var txtdescripcion= $('#txtdescripcion').val();
  var txtcomando= $('#txtcomando').val();
  var txtimagen1= $('#txtimagen1').val();
  var txtimagen2= $('#txtimagen2').val();
  var cboestado= $('#cboestado').val();

  msg='';
  if(cboidmenu=='' || cboidmenu=='*'){
    msg='Selecciona Menu';
  }else if (txtorden==''){
    msg='Ingresa el Orden correlativo';
  }else if (txtdescripcion==''){
    msg='Ingresa el Submenu';
  }else if (txtcomando==''){
    msg='Ingresa el comando';
  }else if (txtimagen1==''){
    msg='Digita la Imagen 1';
  }else if (txtimagen2==''){
    msg='Digita Imagen 2';
  }else if (cboestado==''|| cboestado=='*'){
    msg='Selecciona estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INS';
  } else if (opt=='U'){
    act='UPD';
  }else {
    act='DEL';
  }

  $.post('../controller/ctrlMenus.php', {

    cboidmenu:cboidmenu,
    cboidmenudes:cboidmenudes,
    txtorden:txtorden,
    txtdescripcion:txtdescripcion,
    txtcomando:txtcomando,
    txtimagen1:txtimagen1,
    txtimagen2:txtimagen2,
    cboestado:cboestado,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#tblMenus').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Menu Grabado');
      //applyPerN(responseText);
    }
  });
}



function placeItemTable(idtabla,idtipo,desc,abrev,idest){
  $('#txtidtabla').val(idtabla) ;
  $('#txtoption').val('U');
  //$('#txtabrevdep').val(nomusr);
  $('#txtidtipo').val(idtipo);
  $('#txtdescripciontable').val(desc);
  $('#txtabrevtable').val(abrev);
  $('#cboestado').val(idest);
  $("#saveTable").text('Actualizar');
}


function newTable(){
  $('#cboidtabla').val('') ;
  $('#txtoption').val('I');
  //$('#txtabrevdep').val(nomusr);
  //$('#txtidtipo').val('');
  $('#txtdescripciontable').val('');
  $('#txtabrevtable').val('');
  $('#cboestado').val('');
  $("#saveTable").text('Grabar');

}

function placeItemusr(idusr,login,iddep,idper,idcargo,idrol,idest){
  $('#txtidusr').val(idusr).attr("disabled","true");
  $('#txtlogin').val(login);
  $('#txtoption').val('U');
  //$('#txtabrevdep').val(nomusr);
  $('#cbodestinatariousr').val(iddep);
  //$("#cbodestinatariousr option:selected").prop("selected", true);
  $("#cbodestinatariousr").multiselect('refresh');
  $('#cboidpersonal').val(idper);
  //$("#cboidpersonal option:selected").prop("selected", true);
  $("#cboidpersonal").multiselect('refresh');
  $('#cbocargo').val(idcargo);
  //$("#cbocargo option:selected").prop("selected", true);
  $("#cbocargo").multiselect('refresh');
  $('#cborol').val(idrol);
  //$("#cborol option:selected").prop("selected", true);
  $("#cborol").multiselect('refresh');
  $('#cboestado').val(idest);
  //$("#cboestado option:selected").prop("selected", true);
  //$("#cboestado").multiselect('refresh');
  $("#saveUsr").text('Actualizar');
}


function placeItemsede(id,nom,abrev,dir,tel,identidad,es){
  $('#txtcodigo').val(id).attr("disabled","true");
  $('#txtdescripcion').val(nom);
  $('#txtabrevdep').val(abrev);
  $('#txtdireccion').val(dir);
  $('#txttelefono').val(tel);
  $('#cboidentidad').val(identidad);
  $('#cboestado').val(es);
  $("#saveSede").text('Actualizar');
  $('#txtoption').val('U');

}

function newSede(){
  $('#cboidentidad').val('*');
  $('#txtdescripcion').val('');
  $('#txtcodigo').val('');
  $('#txtabrevdep').val('');
  $('#txtdireccion').val('');
  $('#txttelefono').val('');
  $('#cboestado').val('*');
  $('#txtoption').val('I');
  $("#saveSede").text('Grabar');
}

function saveSede(){
  var cboidentidad=$('#cboidentidad').val();
  var txtdescripcion= $('#txtdescripcion').val();
  var txtcodigo= $('#txtcodigo').val();
  var txtabrevdep= $('#txtabrevdep').val();
  var txtdireccion= $('#txtdireccion').val();
  var txttelefono= $('#txttelefono').val();
  var cboestado= $('#cboestado').val();
  var opt= $('#txtoption').val();

  msg='';
  if(cboidentidad=='' || cboidentidad=='*'){
    msg='Selecciona Entidad';
  }else if (txtdescripcion==''){
    msg='Ingresa el Nombre de la Sede';
  }else if (txtabrevdep==''){
    msg='Ingresa la abreviatura';
  }else if (txtdireccion==''){
    msg='Ingresa la Dirección';
  }else if (txttelefono==''){
    msg='Ingresa el Teléfono';
  }else if (cboestado=='' || cboestado=='*'){
    msg='Selecciona Estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INSSEDE';
  } else if (opt=='U'){
    act='UPDSEDE';
  }else {
    act='DELSEDE';
  }

  $.post('../controller/ctrlDependencia.php', {
    cboidentidad:cboidentidad,
    txtdescripcion:txtdescripcion,
    txtabrevdep:txtabrevdep,
    txtcodigo:txtcodigo,
    txtdireccion:txtdireccion,
    txttelefono:txttelefono,
    cboestado:cboestado,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#tblSedeConf').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Sede Grabada');
      //applyPerN(responseText);
    }
  });
}

function placeItemdep(id,nom,abrev,dir,tel,es,corr,idide,iddepsup,nomdepsup,idsede,idnivel,idorgano){
  $('#txtcodigo').val(id).attr("disabled","true");
  $('#txtdescripcion').val(nom);
  $('#txtabrevdep').val(abrev);
  $('#txtdireccion').val(dir);
  $('#txttelefono').val(tel);
  $('#cboestado').val(es);
  $('#txtcorrelativo').val(corr);
  $("#saveDep").text('Actualizar');
  $('#txtoption').val('U');
  $('#cbosede').val(idsede);
  $('#cbotipdep').val(idnivel);
  $('#cbotiporgano').val(idorgano);
  //$('#cbodeppadre').val(iddepsup);
  $('#cbodeppadre').val(iddepsup);
  $("#cbodeppadre option:selected").prop("selected", true);
  $("#cbodeppadre").multiselect('refresh');
  $('#cboidentidad').val(idide);

}

function saveDep(){
  var cboidentidad=$('#cboidentidad').val();
  var txtcorrelativo= $('#txtcorrelativo').val();
  var txtdescripcion= $('#txtdescripcion').val();
  var txtcodigo= $('#txtcodigo').val();
  var txtabrevdep= $('#txtabrevdep').val();
  var txtdireccion= $('#txtdireccion').val();
  var txttelefono= $('#txttelefono').val();
  var cboestado= $('#cboestado').val();
  var opt= $('#txtoption').val();

  msg='';
  if(cboidentidad=='' || cboidentidad=='*'){
    msg='Selecciona Entidad';
  }else if (txtdescripcion==''){
    msg='Ingresa el Nombre del Equipo';
  }else if (txtabrevdep==''){
    msg='Ingresa la abreviatura';
  }else if (txtdireccion==''){
    msg='Ingresa la Dirección';
  }else if (txttelefono==''){
    msg='Ingresa el Teléfono';
  }else if (cboestado=='' || cboestado=='*'){
    msg='Selecciona Estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INS';
  } else if (opt=='U'){
    act='UPD';
  }else {
    act='DEL';
  }

  $.post('../controller/ctrlDependencia.php', {
    cboidentidad:cboidentidad,
    txtcorrelativo:txtcorrelativo,
    txtdescripcion:txtdescripcion,
    txtabrevdep:txtabrevdep,
    txtcodigo:txtcodigo,
    txtdireccion:txtdireccion,
    txttelefono:txttelefono,
    cboestado:cboestado,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#tblDependenciaConf').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Dependencia Grabada');
      //applyPerN(responseText);
    }
  });
}


function saveDepAll(){
  //alert($('#txtoption').val());return false;
  var cboidentidad=$('#cboidentidad').val();
  var txtcorrelativo= $('#txtcorrelativo').val();
  var txtdescripcion= $('#txtdescripcion').val();
  var txtcodigo= $('#txtcodigo').val();
  var txtabrevdep= $('#txtabrevdep').val();
  var txtdireccion= $('#txtdireccion').val();
  var txttelefono= $('#txttelefono').val();
  var cboestado= $('#cboestado').val();
  var cbosede= $('#cbosede').val();
  var cbotiporgano= $('#cbotiporgano').val();
  var cbotipdep= $('#cbotipdep').val();
  var cbodeppadre= $('#cbodeppadre').val();
  var opt= $('#txtoption').val();

  msg='';
  if(cboidentidad=='' || cboidentidad=='*'){
    msg='Selecciona Entidad';
  }else if (cbosede=='' || cbosede=='*'){
    msg='Selecciona Sede';
  }else if (cbotiporgano=='' || cbotiporgano=='*'){
    msg='Selecciona Organo';
  }else if (cbotiporgano=='' || cbotiporgano=='*'){
    msg='Selecciona Organo';
  }else if (cbodeppadre=='' || cbodeppadre=='*' || cbodeppadre==null){
    msg='Selecciona Dependencia Superior';
  }else if (txtdescripcion==''){
    msg='Ingresa el Nombre del Equipo';
  }else if (txtabrevdep==''){
    msg='Ingresa la abreviatura';
  }else if (txtdireccion==''){
    msg='Ingresa la Dirección';
  }else if (txttelefono==''){
    msg='Ingresa el Teléfono';
  }else if (cboestado=='' || cboestado=='*'){
    msg='Selecciona Estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INSALL';
  } else if (opt=='U'){
    act='UPDALL';
  }else {
    act='DELALL';
  }

  $.post('../controller/ctrlDependencia.php', {
    cboidentidad:cboidentidad,
    txtcorrelativo:txtcorrelativo,
    txtdescripcion:txtdescripcion,
    txtabrevdep:txtabrevdep,
    txtcodigo:txtcodigo,
    txtdireccion:txtdireccion,
    txttelefono:txttelefono,
    cboestado:cboestado,
    cbosede:cbosede,
    cbotiporgano:cbotiporgano,
    cbotipdep:cbotipdep,
    cbodeppadre:cbodeppadre,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#tblDependenciaConf').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Dependencia Grabada');
      //applyPerN(responseText);
      loadDeptipo('');
    }
  });
}

function newDep(){
  $('#cboidentidad').val('*');
  $('#txtcorrelativo').val('');
  $('#txtdescripcion').val('');
  $('#txtcodigo').val('');
  $('#txtabrevdep').val('');
  $('#txtdireccion').val('');
  $('#txttelefono').val('');
  $('#cboestado').val('*');
  $('#txtoption').val('I');
  $('#cbotipdep').val('*');
  $('#cbotiporgano').val('*');
  $('#cbosede').val('*');
  $("option:selected").removeAttr("selected");
  $("#cbodeppadre").multiselect('refresh');
  loadDeptipo('');
  $("#saveDep").text('Grabar');
}

function newUsr(){
  $("option:selected").removeAttr("selected");
  $("#cbodestinatariousr").multiselect('refresh');
  $("#cboidpersonal").multiselect('refresh');
  $("#cbocargo").multiselect('refresh');
  $("#cborol").multiselect('refresh');
  //$("#cboestado").multiselect('refresh');
  $('#txtlogin').val('');
  $('#txtoption').val('I');
  $('#txtidusr').val('');
  $("#saveUsr").text('Grabar');
}

function saveUsr(){
  var cbodestinatariousr= $('#cbodestinatariousr').val();
  var cboidpersonal= $('#cboidpersonal').val();
  var txtlogin= $('#txtlogin').val();
  var txtpsswd= $('#txtpsswd').val();
  var cbocargo= $('#cbocargo').val();
  var cborol= $('#cborol').val();
  var cboestado= $('#cboestado').val();
  var opt= $('#txtoption').val();
  var idusuario= $('#txtidusr').val();
  msg='';
  if(cbodestinatariousr=='' || cbodestinatariousr=='*' || cbodestinatariousr==null ){
    msg='Selecciona Dependencia';
  }else if (cboidpersonal=='' || cboidpersonal=='*' || cboidpersonal==null ){
    msg='Selecciona Persona';
  }else if (txtlogin==''){
    msg='Ingresa el Login';
  }else if (cboestado=='' || cboestado=='*'  || cboestado==null){
    msg='Selecciona Estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INS';
  } else if (opt=='U'){
    act='UPD';
  }else {
    act='DEL';
  }

  $.post('../controller/ctrlUsuario.php', {
    cbodestinatariousr:$('#cbodestinatariousr').val().join(),
    cboidpersonal:$('#cboidpersonal').val().join(),
    txtlogin:txtlogin,
    txtpsswd:txtpsswd,
    cbocargo:$('#cbocargo').val().join(),
    cborol:$('#cborol').val().join(),
    cboestado:cboestado,
    accion:act,
    idusuario:idusuario

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#tblUsuarioConf').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Usuario Grabado');
      //applyPerN(responseText);
    }
  });
}

function saveOfi(){
  var cboidentidad=$('#cboidentidad').val();
  var cboequipo=$('#cboequipo').val();
  var txtcorrelativo= $('#txtcorrelativo').val();
  var txtdescripcion= $('#txtdescripcion').val();
  var txtcodigo= $('#txtcodigo').val();
  var txtabrevdep= $('#txtabrevdep').val();
  var txtdireccion= $('#txtdireccion').val();
  var txttelefono= $('#txttelefono').val();
  var cboestado= $('#cboestado').val();
  var opt= $('#txtoption').val();

  msg='';
  if(cboidentidad=='' || cboidentidad=='*'){
    msg='Selecciona Entidad';
  }else if (cboequipo==''){
    msg='Selecciona el Equipo Funcional';
  }else if (txtdescripcion==''){
    msg='Ingresa el Nombre del Equipo';
  }else if (txtabrevdep==''){
    msg='Ingresa la abreviatura';
  }else if (txtdireccion==''){
    msg='Ingresa la Dirección';
  }else if (txttelefono==''){
    msg='Ingresa el Teléfono';
  }else if (cboestado=='' || cboestado=='*'){
    msg='Selecciona Estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='IO') {
    act='INSO';
  } else if (opt=='UO'){
    act='UPDO';
  }else {
    act='DEL';
  }

  $.post('../controller/ctrlDependencia.php', {
    cboidentidad:cboidentidad,
    cboequipo:cboequipo,
    txtcorrelativo:txtcorrelativo,
    txtdescripcion:txtdescripcion,
    txtabrevdep:txtabrevdep,
    txtcodigo:txtcodigo,
    txtdireccion:txtdireccion,
    txttelefono:txttelefono,
    cboestado:cboestado,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#tblOficinaConf').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Oficina Grabada');
      //applyPerN(responseText);
    }
  });
}

function newOfi(tipo){
  if(tipo=='All'){
    $('#cboidentidad').val('*');
    $('#cboequipo').val('*');
  }
  $('#txtcorrelativo').val('');
  $('#txtdescripcion').val('');
  $('#txtcodigo').val('');
  $('#txtabrevdep').val('');
  $('#txtdireccion').val('');
  $('#txttelefono').val('');
  $('#cboestado').val('*');
  $('#txtoption').val('IO');
  $("#saveOfi").text('Grabar');
}

function placeItemofi(id,nom,abrev,dir,tel,es,corr,idide,idpat){
  $('#txtcodigo').val(id).attr("disabled","true");
  $('#txtdescripcion').val(nom);
  $('#txtabrevdep').val(abrev);
  $('#txtdireccion').val(dir);
  $('#txttelefono').val(tel);
  $('#cboestado').val(es);
  $('#txtcorrelativo').val(corr);
  $("#saveOfi").text('Actualizar');
  $('#txtoption').val('UO');
  $('#cboidentidad').val(idide);
  $('#cboequipo').val(idpat);

}

function placeItemare(id,nom,abrev,dir,tel,es,corr,idide,idpat,idof){
  $('#txtcodigo').val(id).attr("disabled","true");
  $('#txtdescripcion').val(nom);
  $('#txtabrevdep').val(abrev);
  $('#txtdireccion').val(dir);
  $('#txttelefono').val(tel);
  $('#cboestado').val(es);
  $('#txtcorrelativo').val(corr);
  $("#saveOfi").text('Actualizar');
  $('#txtoption').val('UA');
  $('#cboidentidad').val(idide);
  $('#cboequipo').val(idof);
  $('#cbooficina').val(idpat);
}


function newAre(tipo){
  if(tipo=='All'){
    $('#cboidentidad').val('*');
    $('#cboequipo').val('*');
  }
  $('#txtcorrelativo').val('');
  $('#txtdescripcion').val('');
  $('#txtcodigo').val('');
  $('#txtabrevdep').val('');
  $('#txtdireccion').val('');
  $('#txttelefono').val('');
  $('#cboestado').val('*');
  $('#txtoption').val('I');
  $("#saveOfi").text('Grabar');
}

function loadOficinas(val){
  $("#cbooficina").load("../controller/ctrlMain.php?action=cboOfi&id_equipo="+val , function () {
    $("#cbooficina").selectmenu("refresh");
  });
}

function loadDeptipo__(val){
  //alert('a');return false;
  $("#cbodeppadre").load("../controller/ctrlMain.php?action=cbodeptipo&idtipo="+val , function () {
    $("#cbodeppadre").selectmenu("refresh");
  });
}

function loadDeptipo(val){
  var parametros = {"action":"cbodeptipo","idtipo": val };
  //$("#dialog-loading").dialog("open");
  $.ajax({
    data:  parametros,
    url:   '../controller/ctrlMain.php',
    type:  'get',
    beforeSend: function () {
      //$("#resultado").html("Procesando, espere por favor...");
    },
    success:  function (response) {
      $("#region_dependencias").html(response);
      $(document).ready(function() {
        $('#cbodeppadre').multiselect({
          buttonWidth: '100%',
          buttonClass: 'btn btn-default input-sm btn-small',
          nSelectedText: 'Seleccionados',
          nonSelectedText: 'Seleccionar',
          inheritClass: true,
          enableFiltering: true,
          enableCaseInsensitiveFiltering: true,
          maxHeight: 330,
          /*buttonText: function(options, select){
          return 'Seleccione Personal';
          //alert(options.length);
        },*/
      });
    });
    //$('#cboidpersonal').attr("disabled","true");
    //show_oficinas();
  }
});
}

function loadImgReniec(){
  var parametros = {"action":"LoadImgReniec"};
  $.ajax({
    data:  parametros,
    url:   '../controller/ctrlMain.php',
    type:  'get',
    beforeSend: function () {
      $("#div_img").html("<img src='../dist/img/ajax-loader.gif' >");
    },
    success:  function (response) {
      $("#div_img").html(response);
    }
  });
}


function ShowCaptchaR()
{
  var nro = document.getElementById('nro_doc').value.length;
  if (nro != 8)
  {
    alert('Ingrese Nro correcto de 8 digitos');
    document.getElementById('nro_doc').focus();
    return false
  }
  else
  {
    //reload_captcha_sunat();
    $('#myModal_wcaptchaReniec').modal('show');
    document.getElementById('txtcaptcha').value='';
    document.getElementById('txtcaptcha').focus();

  }
}

function busca_ruc()
{
  var nro = document.getElementById('ruc').value.length;
  if (nro != 11)
  {
    alert('Ingrese Nro correcto de 11 digitos');
    document.getElementById('ruc').focus();
    return false
  }
  else
  {
    reload_captcha_sunat();
    //$('#myModal_wcaptcha').modal('show');
    document.getElementById('txtcaptcha').value='';
    document.getElementById('txtcaptcha').focus();

  }
}



httplpw = getXMLHTTPRequest();
function reload_captcha_sunat(){
  myRand = parseInt(Math.random()*999999999999999);
  var myurl = '../controller/ctrlMain.php';
  var modurl = myurl + "?action=ReLoadCaptchaSunat&rand=" + myRand;
  httplpw.open("GET", modurl, true);
  httplpw.onreadystatechange = useHttpResponseCaptcha;
  httplpw.send(null);
}

function useHttpResponseCaptcha(){
  if (httplpw.readyState == 4) {
    if(httplpw.status == 200) {
      var miTexto = httplpw.responseText;
      document.getElementById('div_captcha').innerHTML =(miTexto);
    }
  } else {
    document.getElementById('div_captcha').innerHTML = "<img src='../dist/img/ajax-loader.gif' border='0'>";
  }
}


httpot=getXMLHTTPRequest();
function get_sunat(){
  myRand = parseInt(Math.random()*999999999999999);
  if(document.getElementById('txtcaptcha').value==''){
    alert('Ingrese el codigo Captcha');
    document.getElementById('txtcaptcha').focus();
    return false;
  }
  //$('#myModal_wcaptcha').modal('hide');
  $('#myModal_search').modal('show');
  var myurl = '../controller/ctrlMain.php';
  var modurl = myurl + "?action=LoadCaptcha&txtcaptcha=" + document.getElementById('txtcaptcha').value + "&txtruc=" + document.getElementById('ruc').value + "&txtsesionruc=" + document.getElementById('txtsesionruc').value + "&rand=" + myRand;
  httpot.open("GET", modurl, true);
  httpot.onreadystatechange = useHttpResponseDataSunat;
  httpot.send(null);
}

function useHttpResponseDataSunat(){
  if (httpot.readyState == 4) {
    if(httpot.status == 200) {
      var miTexto = httpot.responseText;
      $('#myModal_search').modal('hide');
      if (miTexto=='01'){
        alert('Codigo ingresado es incorrecto');
        //$('#myModal_wcaptcha').modal('hide');
        document.getElementById('ruc_w').focus();
        return false
      }
      if (miTexto=='02'){
        alert('Numero de RUC no existe');
        //$('#myModal_wcaptcha').modal('hide');
        document.getElementById('ruc').focus();
        return false
      }
      document.getElementById('div_error').innerHTML = (miTexto);
      //alert(miTexto);return false;
      document.getElementById('txtorganizacion').value=document.getElementById('nom_raz_soc_w').value;

    }
  } else {
    //document.getElementById('div_captcha').innerHTML = "<img src='img/ajax-loader.gif' border='0'>";
  }
}

function newOrg(){
  $('#myModal_newPersonaJ').modal('show');
  $("#typej").val('I');
  $("#idpersonaj").val('');
  reload_captcha_sunat();

}

function newPer(){
  $('#myModal_newPersonaN').modal('show');
  $("#type").val("I");
  $("#idpersona").val('');

}

function savePerJ(){
  var ruc=$('#ruc').val();
  var txtorganizacion= $('#txtorganizacion').val();
  var cbotipoper= $('#cbotipoper').val();
  var cbocategoriaper= $('#cbocategoriaper').val();
  var typej= $('#typej').val();
  var idpersonaj= $('#idpersonaj').val();
  var opt=typej;
  msg='';
  if(ruc==''){
    msg='Ingresa el RUC';
  }else if (txtorganizacion==''){
    msg='Ingresa el nombre de la Institucion';
  }else if (cbotipoper=='' || cbotipoper=='*'){
    msg='Selecciona Tipo';
  }else if (cbocategoriaper=='' || cbocategoriaper=='*'){
    msg='Selecciona Categoria';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INS';
  } else if (opt=='U'){
    act='INSJ';
  }else {
    act='DEL';
  }
  //alert(cboaccion);return false;
  $.post('../controller/ctrlPersona.php', {
    ruc:ruc,
    txtorganizacion:txtorganizacion,
    cbotipoper:cbotipoper,
    cbocategoriaper:cbocategoriaper,
    idpersonaj:idpersonaj,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='1'){
      msg='Ya existe una Institucion con este RUC';
      alert(msg); return false;
    }else if (responseText=='2'){
      $('#myModal_newPersonaJ').modal('hide');
      alert_principal('success', 'Institucion Actualizada');
      var table = $('#tblPersonaConf').DataTable();
      table.ajax.reload();
      $(location).attr('href','GridPersona.php')
    }else{
      $('#myModal_newPersonaJ').modal('hide');
      alert_principal('success', 'Institucion Registrada');
      var table = $('#tblPersonaConf').DataTable();
      table.ajax.reload();
      $(location).attr('href','GridPersona.php')
    }
  });


}

function savePerN(){
  var txtnro_doc=$('#txtnro_doc').val();
  var txtapepat= $('#txtapepat').val();
  var txtapemat= $('#txtapemat').val();
  var txtnombres= $('#txtnombres').val();
  var cbotipoperN= $('#cbotipoperN').val();
  //var cbocategoriaperN= $('#cbocategoriaperN').val();
  var cbosexoperN= $('#cbosexoperN').val();
  var txttelefonoN= $('#txttelefonoN').val();
  var txtdireccionN= $('#txtdireccionN').val();
  var txtmailN= $('#txtmailN').val();
  var opt = $("#type").val();
  var idpersona = $("#idpersona").val();
  //alert(txtnombres);return false;
  msg='';
  if(txtnro_doc==''){
    msg='Ingresa el DNI';
  }else if (txtapepat==''){
    msg='Ingresa el Apellido Paterno';
  }else if (txtapemat==''){
    msg='Ingresa el Apellido Materno';
  }else if (txtnombres==''){
    msg='Ingresa los Nombres';
  }else if (cbotipoperN=='' || cbotipoperN=='*'){
    msg='Selecciona Tipo';
  }else if (cbosexoperN=='' || cbosexoperN=='*'){
    msg='Selecciona Sexo';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INSN';
  } else if (opt=='U'){
    act='UPD';
  }else {
    act='DEL';
  }

  $.post('../controller/ctrlPersona.php', {
    txtnro_doc:txtnro_doc,
    txtapepat:txtapepat,
    txtapemat:txtapemat,
    txtnombres:txtnombres,
    cbotipoperN:cbotipoperN,
    cbosexoperN:cbosexoperN,
    txttelefonoN:txttelefonoN,
    txtdireccionN:txtdireccionN,
    txtmailN:txtmailN,
    accion:act,
    idpersona:idpersona

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='1'){
      msg='Ya existe una Persona con este DNI';
      alert(msg); return false;
    }else if (responseText=='2'){
      $('#myModal_newPersonaN').modal('hide');
      alert_principal('success', 'Persona Actualizada');
      var table = $('#tblPersonaConf').DataTable();
      table.ajax.reload();
    }else{
      $('#myModal_newPersonaN').modal('hide');
      alert_principal('success', 'Persona Registrada');
      var table = $('#tblPersonaConf').DataTable();
      table.ajax.reload();
    }
  });
}

function applyPerN(PerN){
  var parametros = {"action":"Find_PersonaN","PerNa":PerN};
  $.ajax({
    data:  parametros,
    url:   '../controller/ctrlMain.php',
    type:  'get',
    dataType: "json",
    beforeSend: function () {
      //$("#resultado").html("Procesando, espere por favor...");
    },
    success:  function (response) {
      //alert(response); return false;
      $('#txtsearchPersona').val(response.nombre_rs);
      $('#txtidpersona').val(response.id_persona);
    }
  });
}


function buscaDNI(){

  var parametros = {"action":"LoadDataReniec", "txtsession_reniec":$("#txtsesion_reniec").val(),"txtimg":$("#txtimg").val(),"nro_doc":$("#txtnro_doc").val()};
  //var parametros = {"accion":"LOAD_DATOS_RENIEC", "txtimg":$("#txtimg").val(),"nro_doc":$("#nro_doc").val()};
  $.ajax({
    data:  parametros,
    url:   '../controller/ctrlMain.php',
    type:  'post',
    beforeSend: function () {
      $("#reniec-loading").modal("show");
      //$("#tblEstudios").html("<img src='../img/cargando_small.gif' >");

    },
    success:  function (response) {
      //$("#div_respuesta").html(response);
      $("#reniec-loading").modal("hide");
      if (response=='01'){
        //alert('No se hallo documento en BD RENIEC');
        alert("No se hallo documento en BD RENIEC");
      }else if(response=='02'){
        alert("La sesion de consulta RENIEC ha expirado, vuelva a recargar la pagina");
      }else if (response=='03'){
        alert("Ingrese el codigo que aparece en la imagen");
      }else if (response=='04'){
        alert("Ocurrio un error en la consulta");
      }else{
        //$('#myModal_wcaptchaReniec').modal('hide');
        var data=response.split("||");
        $('#txtnombres').val(data[0].trim());
        $('#txtapepat').val(data[1].trim());
        $('#txtapemat').val(data[2].trim());
      }
    }
  });
}



function showinfoPer(idpersona){

  var parametros = {"action":"LoadInfoPersona", "idpersona":idpersona};
  $.ajax({
    data:  parametros,
    url:   '../controller/ctrlMain.php',
    type:  'post',
    beforeSend: function () {
      $("#modalinfoPer").modal("show");
      //$("#tblEstudios").html("<img src='../img/cargando_small.gif' >");
    },
    success:  function (response) {
      $("#divinfoPer").html(response);
      //$("#reniec-loading").modal("hide");
    }
  });
}


$(document).ready(function() {
  /*ORDENAR LOS SELECCIONADOS */
  var orderCount = 0;
  $('#cbodestinatario').multiselect({
    onChange: function(option, checked) {
      /*PARA SELECCIONAR UNA CANTIDAD DETERMINADA */
      var selectedOptions = $('#cbodestinatario option:selected');
      var tipodoc = 1;
      if (selectedOptions.length >= tipodoc) {
        // Disable all other checkboxes.
        var nonSelectedOptions = $('#cbodestinatario option').filter(function() {
          return !$(this).is(':selected');
        });

        nonSelectedOptions.each(function() {
          var input = $('input[value="' + $(this).val() + '"]');
          input.prop('disabled', true);
          input.parent('li').addClass('disabled');
        });
      }
      else {
        // Enable all checkboxes.
        $('#cbodestinatario option').each(function() {
          var input = $('input[value="' + $(this).val() + '"]');
          input.prop('disabled', false);
          input.parent('li').addClass('disabled');
        });
      }
      if (checked) {
        orderCount++;
        $(option).data('order', orderCount);
      }
      else {
        $(option).data('order', '');
      }
    },/*FIN DE ORDENAR LOS SELECCIONADOS*/
    onDropdownHide: function(event) {

      if($( "#cbotipodoc" ).val()=='2' || $( "#cbotipodoc" ).val()=='5'){
        confirmSaveExpediente();
      }
    },
    includeSelectAllOption: false,
    selectAllName: 'select-all-name',
    nSelectedText: 'Seleccionados',
    nonSelectedText: 'Seleccionar',
    inheritClass: true,
    buttonWidth: '100%',

    buttonClass: 'btn btn-default btn-small input-sm',
    onDropdownHidden: function (e) {
      var selected = [];
      var selectedx = [];
      $('#cbodestinatario option:selected').each(function() {
        selected.push([$(this).val(), $(this).data('order')]);

      });

      selected.sort(function(a, b) {
        return a[1] - b[1];
      });


      var text = '';
      for (var i = 0; i < selected.length; i++) {
        text += selected[i][0] + ',';
      }
      text = text.substring(0, text.length - 1);

      var text=text.split(',');
      //loadPersonal(text);
    }
  });
});

$(document).ready(function() {
  $('#cbocargo').multiselect({
    onChange: function(option, checked) {
  var values = [];
  $('#cbocargo option').each(function() {
    if ($(this).val() !== option.val()) {
      values.push($(this).val());
    }
  });

  $('#cbocargo').multiselect('deselect', values);
},
    includeSelectAllOption: false,
    selectAllName: 'select-all-name',
    nSelectedText: 'Seleccionados',
    nonSelectedText: 'Seleccionar',
    buttonClass: 'btn btn-default btn-small input-sm',
    inheritClass: true,
    buttonWidth: '100%',
    enableFiltering: true,
    enableCaseInsensitiveFiltering: true,
  });

  $('#cbodeppadre').multiselect({
    includeSelectAllOption: false,
    selectAllName: 'select-all-name',
    nSelectedText: 'Seleccionados',
    nonSelectedText: 'Seleccionar',

    buttonClass: 'btn btn-default btn-small input-sm',
    inheritClass: true,
    buttonWidth: '100%',
    enableFiltering: true,
    enableCaseInsensitiveFiltering: true,
    maxHeight: 330,
  });

  $('#cbodestinatariousr').multiselect({
    onChange: function(option, checked) {
  var values = [];
  $('#cbodestinatariousr option').each(function() {
    if ($(this).val() !== option.val()) {
      values.push($(this).val());
    }
  });

  $('#cbodestinatariousr').multiselect('deselect', values);
},
    includeSelectAllOption: false,
    selectAllName: 'select-all-name',
    nSelectedText: 'Seleccionados',
    nonSelectedText: 'Seleccionar',
    enableFiltering: true,
    enableCaseInsensitiveFiltering: true,
    maxHeight: 450,
    buttonClass: 'btn btn-default btn-small input-sm',
    inheritClass: true,
    buttonWidth: '100%',
  });

  $('#cborol').multiselect({
    onChange: function(option, checked) {
  var values = [];
  $('#cborol option').each(function() {
    if ($(this).val() !== option.val()) {
      values.push($(this).val());
    }
  });

  $('#cborol').multiselect('deselect', values);
},
    includeSelectAllOption: false,
    selectAllName: 'select-all-name',
    nSelectedText: 'Seleccionados',
    nonSelectedText: 'Seleccionar',
    /*buttonText: function(options, select){
    return 'Seleccione Accion';
    //alert(options.length);
  },*/
  buttonClass: 'btn btn-default btn-small input-sm',
  inheritClass: true,
  buttonWidth: '100%',
});

/*ORDENAR LOS SELECCIONADOS */
var orderCount = 0;
$('#cboidpersonal').multiselect({
  onChange: function(option, checked) {
  var values = [];
  $('#cboidpersonal option').each(function() {
    if ($(this).val() !== option.val()) {
      values.push($(this).val());
    }
  });

  $('#cboidpersonal').multiselect('deselect', values);
},
/*  onDropdownHide: function(event) {

    if($( "#cbotipodoc" ).val()=='2' || $( "#cbotipodoc" ).val()=='5'){
      confirmSaveExpediente();
    }
  },*/
  includeSelectAllOption: false,
  selectAllName: 'select-all-name',
  nSelectedText: 'Seleccionados',
  nonSelectedText: 'Seleccionar',
  inheritClass: true,
  buttonWidth: '100%',
  enableFiltering: true,
  enableCaseInsensitiveFiltering: true,
  maxHeight: 450,
  buttonClass: 'btn btn-default btn-small input-sm',
  onDropdownHidden: function (e) {
    var selected = [];
    var selectedx = [];
    $('#cboidpersonal option:selected').each(function() {
      selected.push([$(this).val(), $(this).data('order')]);

    });

    selected.sort(function(a, b) {
      return a[1] - b[1];
    });


    var text = '';
    for (var i = 0; i < selected.length; i++) {
      text += selected[i][0] + ',';
    }
    text = text.substring(0, text.length - 1);

    var text=text.split(',');
    //loadPersonal(text);
  }
});

});


function deleteItemTable(idtabla,idtipo,desc,abrev,idest){
  $('#txtidtabla').val(idtabla) ;
  $('#txtoption').val('D');
  //$('#txtabrevdep').val(nomusr);
  $('#txtidtipo').val(idtipo);
  $('#txtdescripciontable').val(desc);
  $('#txtabrevtable').val(abrev);
  $('#cboestado').val(idest);
  if (!confirm('Estás seguro de Eliminar este registro ?')){
    return false;
  }
  saveTable();

}

function saveTable(){
  var cboidtabla= $('#cboidtabla').val();
  var txtidtipo= $('#txtidtipo').val();
  var txtdescripciontable= $('#txtdescripciontable').val();
  var txtabrevtable= $('#txtabrevtable').val();
  var cboestado= $('#cboestado').val();
  var opt= $('#txtoption').val();
  msg='';
  if(cboidtabla=='' || cboidtabla=='*'){
    msg='Selecciona Tabla';
  }else if (txtdescripciontable==''){
    msg='Ingresa Descripcion';
  }else if (cboestado=='' || cboestado=='*'  || cboestado==null){
    msg='Selecciona Estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INS';
  } else if (opt=='U'){
    act='UPD';
  }else {
    act='DEL';
  }

  $.post('../controller/ctrlTablas.php', {
    cboidtabla:cboidtabla,
    txtidtipo:txtidtipo,
    txtdescripciontable:txtdescripciontable,
    txtabrevtable:txtabrevtable,
    cboestado:cboestado,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#exampleConf').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Tabla Grabado');
      //applyPerN(responseText);
    }
  });
}



function saveAre(){
  var cboidentidad=$('#cboidentidad').val();
  var cboequipo=$('#cboequipo').val();
  var cbooficina=$('#cbooficina').val();
  var txtcorrelativo= $('#txtcorrelativo').val();
  var txtdescripcion= $('#txtdescripcion').val();
  var txtcodigo= $('#txtcodigo').val();
  var txtabrevdep= $('#txtabrevdep').val();
  var txtdireccion= $('#txtdireccion').val();
  var txttelefono= $('#txttelefono').val();
  var cboestado= $('#cboestado').val().join();
  var opt= $('#txtoption').val();

  msg='';
  if(cboidentidad=='' || cboidentidad=='*'){
    msg='Selecciona Entidad';
  }else if (cboequipo==''){
    msg='Selecciona el Equipo Funcional';
  }else if (cbooficina==''){
    msg='Selecciona la Oficina';
  }else if (txtdescripcion==''){
    msg='Ingresa el Nombre del Equipo';
  }else if (txtabrevdep==''){
    msg='Ingresa la abreviatura';
  }else if (txtdireccion==''){
    msg='Ingresa la Dirección';
  }else if (txttelefono==''){
    msg='Ingresa el Teléfono';
  }else if (cboestado=='' || cboestado=='*'){
    msg='Selecciona Estado';
  }

  if(msg!=''){	alert (msg); return false;	}

  if (opt=='I') {
    act='INSA';
  } else if (opt=='UA'){
    act='UPDA';
  }else {
    act='DELA';
  }

  $.post('../controller/ctrlDependencia.php', {
    cboidentidad:cboidentidad,
    cboequipo:cboequipo,
    cbooficina:cbooficina,
    txtcorrelativo:txtcorrelativo,
    txtdescripcion:txtdescripcion,
    txtabrevdep:txtabrevdep,
    txtcodigo:txtcodigo,
    txtdireccion:txtdireccion,
    txttelefono:txttelefono,
    cboestado:cboestado,
    accion:act

  }, function (responseText) {
    //alert(responseText);return false;
    if (responseText=='-1'){
      msg='Error en transaccion';
      alert("Error en transaccion"); return false;
    }else{
      //$('#myModal_newPersonaN').modal('hide');
      var table = $('#tblAreaConf').DataTable();
      table.ajax.reload();
      alert_principal('success', 'Area Grabada');
      //applyPerN(responseText);
    }
  });
}



function placeItemper(idpersona,idtipo)
{
  if(idpersona)
  {
    $.ajax({
      type: "GET",
      url: "../controller/ctrlMain.php",
      dataType: 'json',
      data: {idpersona:idpersona,action:"EDIT_PER"},
      success: function(res) {
        //waitingDialog.hide();
        setModalData( res );
      }
    });
  }
  // Untuk Tambahkan Data
  else
  {
    $("#myModal_newPersonaN").modal("show");
    $("#titleModaPern").html("Editar Persona");
    $("#type").val("UPD");

  }
}
//Data Yang Ingin Di Tampilkan Pada Modal Ketika Di Edit


function clearPerJ(){
  $(location).attr('href','GridPersona.php');
  //alert('2');
}

function setModalData( data )    {
  var datos = eval(data);
  if(datos[0]=='1'){
    $("#titleModaPern").html('Editar Persona : ' + datos[2]);
    $("#type").val("U");
    $("#idpersona").val(datos[1]);
    $("#txtnro_doc").val(datos[5]).attr("disabled","true");
    $("#txtapepat").val(datos[3]);
    $("#txtapemat").val(datos[4]);
    $("#txtnombres").val(datos[2]);
    $("#txttelefonoN").val(datos[8]);
    $("#cbotipoperN").val(datos[0]);
    $("#cbosexoperN").val(datos[9]);
    $("#txtdireccionN").val(datos[6]);
    $("#txtmailN").val(datos[7]);
    $("#myModal_newPersonaN").modal("show");
  }else{
    $("#myModal_newPersonaJ").modal("show");
    $("#typej").val("U");
    $("#idpersonaj").val(datos[1]);
    $("#ruc").val(datos[5]).attr("disabled","true");
    $("#txtorganizacion").val(datos[2]);
    $("#cbotipoper").val(datos[10]);
    $("#cbocategoriaper").val(datos[11]);
  }
  //alert(data.id_distrito.substr(0,2));
}
