<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">
<head>
	<title>jQuery Datetime Picker</title>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
	<style type="text/css">
			body,img,p,h1,h2,h3,h4,h5,h6,form,table,td,ul,li,dl,dt,dd,pre,blockquote,fieldset,label{
				margin:0;
				padding:0;
				border:0;
			}
			body{ background-color: #363531; border-top: solid 4px #C60; font: 90% Arial, Helvetica, sans-serif; padding: 20px; }
			h1,h2{ margin: 10px 0; }
			p{ margin: 10px 0; }

			pre{ padding: 20px; background-color: #ffffcc; border: solid 1px #fff; }
			.wrapper{ background-color: #ffffff; width: 800px; border: solid 1px #eeeeee; padding: 20px; margin: 0 auto; }
			.example-container{ background-color: #f4f4f4; border-bottom: solid 2px #777777; margin: 0 0 40px 0; padding: 20px; }
			.example-container p{ font-weight: bold; }
			.example-container dt{ font-weight: bold; height: 20px; }
			.example-container dd{ margin: -20px 0 10px 100px; border-bottom: solid 1px #fff; }
			.example-container input{ width: 150px; }
			.clear{ clear: both; }
			#ui-datepicker-div{ font-size: 80%; }

			/* css for timepicker */
			.ui-timepicker-div .ui-widget-header{ margin-bottom: 8px; }
			.ui-timepicker-div dl{ text-align: left; }
			.ui-timepicker-div dl dt{ height: 25px; }
			.ui-timepicker-div dl dd{ margin: -25px 10px 10px 65px; }
			.ui-timepicker-div td { font-size: 90%; }

		</style>
		<link type="text/css" href="js/jq/jquery-ui-1.8.13.custom.css" rel="stylesheet" />
		<script type="text/javascript" src="js/jq/jquery-1.5.1.min.js"></script>
		<script type="text/javascript" src="js/jq/jquery-ui-1.8.13.custom.min.js"></script>
		<script type="text/javascript" src="js/jq/jquery-ui-timepicker-addon.js"></script>
		<script type="text/javascript">

			$(function(){
				$('#example1').datetimepicker();

				$('#example2').datetimepicker({
					ampm: true
				});

				$('#example3').timepicker({});

				$('#example5').datetimepicker({
					showSecond: true,
					timeFormat: 'hh:mm:ss'
				});

				$('#example6').datetimepicker({
					showSecond: true,
					timeFormat: 'hh:mm:ss',
					stepHour: 2,
					stepMinute: 10,
					stepSecond: 10
				});

				$('#example7').datetimepicker({
					hour: 13,
					minute: 15,
					second: 59
				});

				$('#example8').timepicker({
					ampm: true,
					hourMin: 8,
					hourMax: 16
				});

				$('#example11').datetimepicker({
					numberOfMonths: 3
				});

				$('#example14').datetimepicker({
					minDate: new Date(2010, 11, 20, 8, 30),
					maxDate: new Date(2010, 11, 31, 17, 30)
				});
			});

		</script>
</head>
<body>
<div class="example-container">

	<h2>DateTime Picker jQuery</h2>

	<p>Add a simple timepicker to jQuery UI's datepicker</p>
	<div>
	 	<input type="text" name="example1" id="example1" value="" />
	</div>

	<p>Show time in AM/PM 12 hour format</p>
	<div>
		<input type="text" name="example2" id="example2" value="" />
	</div>

	<p>Show only the time picker without date picker</p>
	<div>
		<input type="text" name="example3" id="example3" value="" />
	</div>

	<p>Show Seconds, Minutes, or Hours</p>
	<div>
		<input type="text" name="example5" id="example5" value="" />
	</div>

	<p>Hours, Minutes, Seconds in steps</p>
	<div>
		<input type="text" name="example6" id="example6" value="" />
	</div>

	<p>Default Hours, Minutes, Seconds</p>
	<div>
		<input type="text" name="example7" id="example7" value="" />
	</div>

	<p>Set the time range. For instance if you only want to allow the user to choose times between 8AM and 5PM.</p>
	<div>
		<input type="text" name="example8" id="example8" value="" />
	</div>

	<p>When showing more than one month.</p>
	<div>
		<input type="text" name="example11" id="example11" value="" />
	</div>

	<p>Use the datepicker minDate/maxDate options: (note: these must use Date objects)</p>
	<div>
		<input type="text" name="example14" id="example14" value="" />
	</div>
</div>
</body>
</html>