<?php

include '../clases/clinica.class.php';
require('fpdf.php');
session_start();
if (!isset($_SESSION["accessauthority"])) {
  header("location:index.php");
  exit();
}
$idcentro = $_SESSION['idoperativo'];
$cn = conectar();


if (!isset($_GET['idpresupuesto'])) {
  $idpresupuesto = '';
} else {
  $idpresupuesto = $_GET['idpresupuesto'];
}
$cad = "select p.id_presupuesto, p.id_presupuesto,pc.nombre_plantilla,dp.id_item,ic.nombre_item,dp.costo_item,
to_char(p.fecha_registro,'dd/mm/yyyy') as fecha_registro,(pa.ape_paterno||' '||pa.ape_materno||' '||pa.nombre) as paciente,
(me.ape_paterno||' '||me.ape_materno||' '||me.nombres) as medico
from tbl_presupuesto_cirugia p
inner join tbl_plantilla_cirugia pc on p.id_plantilla=pc.id_plantilla
inner join tbl_detalle_presupuesto dp on p.id_presupuesto=dp.id_presupuesto
inner join tbl_item_cirugia ic on dp.id_item=ic.id_item
inner join pacientes pa on pa.id_paciente=p.id_paciente
left join personal me on me.id_personal=dp.id_profesional
where p.id_presupuesto='" . $idpresupuesto . "' order by cast(dp.id_item as int) ";

$rs = pg_query($cn, $cad);
$nr = pg_num_rows($rs);

class PDF extends FPDF {

  //Columna actual
  var $col = 0;
  //Ordenada de comienzo de la columna
  var $y = 34;

  //Cabecera de página
  function Header() {
    //Logo
    //$this->Image('logo_pb.png',10,8,33);
    //Arial bold 15
    //Movernos a la derecha
    $this->AddFont('calibri', '', 'calibri.php');
    $this->AddFont('calibrib', '', 'calibrib.php');
    //$this->Image($_SESSION['s_logo_head_report'],6,6,48,14);
    //$this->Image('../imagenes/head_logo_hc.jpg', 6, 6, 287, 20);
    $this->SetY(10);

    $ti = 'PRESUPUESTO';

    $dat = date('d/m/Y h:i A');
    //$col=ceil((210-strlen($ti))/2);
    //$this->Cell($col);
    //Fecha
    $this->SetFont('calibri', '', 9);
    //$this->Cell(0, 3, 'Fecha: ' . $dat, 0, 1, 'R');
    //Aubtitles
    // $this->Cell(0, 3, 'Pagina: ' . $this->PageNo() . '/{nb}', 0, 1, 'R');
    //$this->SetY(20);
    //Título
    $sub = $_SESSION['operativo'];

    $this->SetFont('calibrib', '', 9);
    //$this->Cell(190, 4, $sub, 0, 1, 'C');



    /*$this->Cell(20, 4,'PRESUPUESTO' , 0, 0, 'L');
    $this->Cell(40, 4," : ".$_GET['idpresupuesto'] , 0, 1, 'C');
    $this->Cell(28, 4,'CIRUGIA' , 0, 0, 'L');
    $this->Cell(40, 4," : ".utf8_decode($_GET['nameplantilla']) , 0, 1, 'C');
    $this->Cell(39, 4,'FECHA' , 0, 0, 'L');
    $this->Cell(19, 4," : ".substr($_GET['fechareg'],0,19) , 0, 1, 'C');
    $this->SetDrawColor(128, 128, 128);
    $this->SetFont('calibrib', '', 8);
    $this->SetDrawColor(128, 128, 128);
    $this->SetFillColor(236, 233, 216);

    $this->Cell(4,4,'','',1,'L');
    $this->Cell(50,4,'ITEM','TB',0,'L');
    $this->Cell(20,4,'MONTO S/.','TB',0,'R');

    $this->Cell(30,4,'','',0,'L');

    $this->Cell(50,4,'ITEM','TB',0,'L');
    $this->Cell(20,4,'MONTO S/.','TB',1,'R');
    /*
    $this->Cell(50, 4, 'ITEM', 'LTBR', 0, 'L', true);
    $this->Cell(20, 4, 'MONTO', 'LTBR', 1, 'L', true);
    */
    $this->SetFont('calibri', '', 9);

  }

  //Pie de página
  function Footer() {
  }
}

function SetCol($col)
{
  //Establecer la posición de una columna dada
  $this->col=$col;
  $x=30+$col*75;
  $this->SetLeftMargin($x);
  $this->SetX($x);
}


function AcceptPageBreak()   {
  //Método que acepta o no el salto automático de página
  if($this->col<1)  {
    //Ir a la siguiente columna
    $this->SetCol($this->col+1);
    //Establecer la ordenada al principio
    $this->SetY($this->y=54);
    //Seguir en esta página
    return false;
  } else {
    //Volver a la primera columna
    //$this->AddPage();
    //$this->SetCol(0);
    $this->col=0;
    $this->SetLeftMargin(3);
    $this->SetX(3);
    //Salto de página
    return true;
  }
}

$pdf=new PDF('P','mm','A4');
//$pdf->SetLeftMargin(6);
$pdf->SetAutoPageBreak(true,4);
$pdf->SetMargins(20,3,3);
$pdf->AliasNbPages();
$pdf->AddPage();


$j = 0;
$v = 0;
//$pdf->SetDrawColor(128,128,128);
$pdf->SetDrawColor(128, 128, 128);
$pdf->SetFillColor(255, 255, 255);


$sw = '0';

for ($g = 0; $g <= 1; $g++) {
  //$pdf->Cell(50, 4, pg_fetch_result($rs, $g, 'nombre_item'), 'LTBR', 0, 'L', true);
  //$pdf->Cell(20, 4, pg_fetch_result($rs, $g, 'costo_item'), 'LTBR', 1, 'R', true);
  $totf = 0;
  $y=$pdf->GetY();
  $pdf->Image('../imagenes/head_logo_hc.jpg', $pdf->GetX(), $pdf->GetY(), 120, 15);
  $pdf->SetY($pdf->GetY()+15);


  $pdf->Cell(22, 4,'PRESUPUESTO' , 0, 0, 'L');
  $pdf->SetFont('calibrib', '', 8);
  $pdf->Cell(40, 4,": ".pg_fetch_result($rs, 0, 'id_presupuesto') , 0, 1, 'L');
  $pdf->SetFont('calibri', '', 8);

  $pdf->Cell(22, 4,'NOMBRE' , 0, 0, 'L');
  $pdf->SetFont('calibrib', '', 8);
  $pdf->Cell(40, 4,": ".utf8_decode(pg_fetch_result($rs, 0, 'paciente')) , 0, 1, 'L');
  $pdf->SetFont('calibri', '', 8);

  $pdf->Cell(22, 4,'CIRUGIA' , 0, 0, 'L');
  $pdf->SetFont('calibrib', '', 8);
  $pdf->Cell(40, 4,": ".utf8_decode(pg_fetch_result($rs, 0, 'nombre_plantilla')) , 0, 1, 'L');
  $pdf->SetFont('calibri', '', 8);

  $pdf->Cell(22, 4,'FECHA' , 0, 0, 'L');
  $pdf->SetFont('calibrib', '', 8);
  $pdf->Cell(10, 4," : ".pg_fetch_result($rs, 0, 'fecha_registro'), 0, 1, 'L');

  $pdf->Cell(22, 4,'' , 0, 1, 'L');

  $pdf->SetFont('calibrib', '', 8);
  $pdf->SetFillColor(236,233,216);
  $pdf->Cell(30,4,'ITEM','LTBR',0,'L',true);

  $pdf->Cell(30,4,'PROFESIONAL','LTBR',0,'L',true);

  $pdf->Cell(20,4,'MONTO S/.','LTBR',1,'R',true);
  $pdf->SetFillColor(255,255,255);
  $pdf->SetFont('calibri', '', 8);

  for ($i = 0; $i < $nr; $i++) {
    $j++;
    $totf=$totf+pg_fetch_result($rs, $i, 'costo_item');
    $pdf->Cell(30, 4, pg_fetch_result($rs, $i, 'nombre_item'), 'LTBR', 0, 'L', true);
    $pdf->Cell(30, 4, utf8_decode(pg_fetch_result($rs, $i, 'medico')), 'LTBR', 0, 'L', true);
    $pdf->Cell(20, 4, pg_fetch_result($rs, $i, 'costo_item'), 'LTBR', 1, 'R', true);
  }
  $pdf->SetFont('calibrib', '', 8);
  $pdf->Cell(60, 4, 'TOTAL S/', 'LTBR', 0, 'R', true);
  $pdf->Cell(20, 4, number_format($totf,2,'.',',') , 'LTBR', 1, 'R', true);
  $pdf->SetFont('calibri', '', 8);

  $pdf->SetY($y);
  $x=30+(2*45);
  $pdf->SetLeftMargin($x);
  $pdf->SetX($x);
}
//$pdf->Cell(50, 4, 'TOTAL', 'LTBR', 0, 'R', true);
//$pdf->Cell(20, 4, number_format($totf,2,'.','') , 'LTBR', 1, 'R', true);
//$pdf->SetFont('calibrib', '', 8);
pg_close($cn);
$pdf->Output();
?>
